/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.modules.javacore;

/**
 *
 * @author Martin Matula
 */
public class Cache {
    private final Object[] instanceCache;
    
    /** Creates a new instance of Cache */
    public Cache(int size) {
        instanceCache = new Object[size];
    }
    
    public void put(Object instance) {
        Object ce = instance;
        for (int i = 0, j = 0; i < instanceCache.length; i++) {
            Object temp = null;
            while (j < instanceCache.length) {
                Object tmp2 = instanceCache[j];
                j++;
                if (tmp2 != null && tmp2 != instance) {
                    if (!(tmp2 instanceof CachedElement) || ((CachedElement) tmp2).isValid()) {
                        temp = tmp2;
                        break;
                    } else {
                        ((CachedElement) tmp2).release();
                    }
                }
            }
            instanceCache[i] = ce;
            ce = temp;
        }
        if (ce != null && (ce instanceof CachedElement)) {
            ((CachedElement) ce).release();
        }
    }
    
    public void dump() {
        System.err.println("******** Cache dump:");
        for (int i = 0; i < instanceCache.length; i++) {
            System.err.println(instanceCache[i].toString());
        }
        System.err.println("*********");
    }
    
    public interface CachedElement {
        void release();
        boolean isValid();
    }
}
