/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.javacore;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.HashSet;
import java.util.Set;
import javax.swing.SwingUtilities;
import org.netbeans.api.mdr.MDRManager;
import org.netbeans.modules.javacore.internalapi.JavaMetamodel;
import org.netbeans.modules.mdr.MDRManagerImpl;
import org.openide.modules.ModuleInstall;
import org.openide.windows.WindowManager;

/** Manages a module's lifecycle.
 * Remember that an installer is optional and often not needed at all.
 *
 * @author Martin Matula
 */
public class JavaCoreModule extends ModuleInstall {
    
    private static volatile boolean startupInProgress = true;
    
    /**
     * Getter for property startupInProgress.
     * @return Value of property startupInProgress.
     */
    static boolean isStartupInProgress() {
        return startupInProgress;
    }
    
    public void restored() {
        final MDRManager manager = MDRManager.getDefault();
        if (manager instanceof MDRManagerImpl) {
            ((MDRManagerImpl) manager).setProgressListener(new ShutDownProgressListener());
        }
        final CompL l = new CompL();
        if (SwingUtilities.isEventDispatchThread()) {
            l.run();
        } else {
            SwingUtilities.invokeLater(l);
        }
        org.netbeans.modules.javacore.internalapi.JavaMetamodel.getManager();
    }
    
    public boolean closing() {
        ((JMManager) JavaMetamodel.getManager()).removeListener();
        return true;
    }
    
    private static class CompL extends WindowAdapter implements Runnable {
        public void windowOpened(WindowEvent e) {
            if (startupInProgress) {
                startupInProgress = false;
                ((JMManager) JMManager.getManager()).startupFinished();
                removeListener(e.getWindow());
            }
        }
        
        private void addListener(Window window) {
            window.addWindowListener(this);
        }
        
        private void removeListener(Window window) {
            window.removeWindowListener(this);
        }
        
        public void run() {
            addListener(WindowManager.getDefault().getMainWindow());
        }
    }
}
