/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.modules.javacore;
import org.netbeans.api.progress.aggregate.AggregateProgressFactory;
import org.netbeans.api.progress.aggregate.AggregateProgressHandle;
import org.netbeans.api.progress.aggregate.ProgressContributor;
import org.netbeans.spi.java.classpath.ClassPathImplementation;
import org.netbeans.modules.javacore.classpath.MergedClassPathImplementation;
import org.netbeans.modules.javacore.internalapi.ProgressListener;
import org.netbeans.modules.javacore.internalapi.ProgressEvent;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeEvent;
import java.text.MessageFormat;
import org.netbeans.api.progress.*;
import org.openide.util.NbBundle;


public class ProgressDisplayer implements ProgressListener, PropertyChangeListener {
    private ClassPathImplementation cp;
    private JMManager model;
    private boolean dirty = false;
    private ProgressContributor progressContributor;
    private ProgressContributor startFake;
    private ProgressContributor endFake;
    private AggregateProgressHandle globalProgress;
    

    private ProgressDisplayer (JMManager model) {
        this.model = model;
        this.cp = model.getMergedClassPathImpl();
        this.cp.addPropertyChangeListener (this);
        this.model.getProgressSupport().addProgressListener (this);
        globalProgress = AggregateProgressFactory.createHandle(NbBundle.getMessage(ProgressDisplayer.class, "TXT_ApplyingPathsTitle"), new ProgressContributor[]{}, null, null);
        globalProgress.start();
        startFake = AggregateProgressFactory.createProgressContributor("startFake"); //NOI18N
        endFake = AggregateProgressFactory.createProgressContributor("endFake"); //NOI18N
        globalProgress.addContributor(startFake);
        globalProgress.addContributor(endFake);
        startFake.start(1);
        endFake.start(1);
    }

    public void start(ProgressEvent event) {
        int ec = event.getCount();
        progressContributor = AggregateProgressFactory.createProgressContributor(Integer.toString(event.hashCode()));
        globalProgress.addContributor(progressContributor);
        progressContributor.start(ec);
        startFake.finish();
    }

    public void step(final ProgressEvent event) {
        progressContributor.progress(event.getCount());
    }

    public void stop(ProgressEvent event) {
        if (JMManager.SCAN_DEBUG) System.err.println("ProgressDisplayer: stop1"); // NOI18N
        if (this.getDirty()) {
            if (JMManager.SCAN_DEBUG) System.err.println("ProgressDisplayer: stop2 - dirty"); // NOI18N
            progressContributor.finish();
            this.startResolution ();
        }
        else {
            if (JMManager.SCAN_DEBUG) System.err.println("ProgressDisplayer: stop3"); // NOI18N
            endFake.finish();
            globalProgress.finish();
            this.model.getProgressSupport().removeProgressListener (this);
            this.cp.removePropertyChangeListener(this);
            instance=null;
        }
    }

    public synchronized void propertyChange(PropertyChangeEvent evt) {
        if (MergedClassPathImplementation.PROP_UNRESOLVED_ROOTS.equals(evt.getPropertyName())) {
            if (JMManager.SCAN_DEBUG) System.err.println("ProgressDisplayer: globalpath changed"); // NOI18N
            this.dirty = true;
        }
    }

    private synchronized boolean getDirty () {
        boolean res = this.dirty;
        this.dirty = false;
        return res;
    }

    private void startResolution() {
        if (JMManager.SCAN_DEBUG) System.err.println("ProgressDisplayer: startResolution"); // NOI18N
        model.startResolution();
    }

    private static ProgressDisplayer instance = null;
    
    private String formatMessage(String message, String parameter) {
        return MessageFormat.format(message, new Object[] {parameter});
    }
    
    public void updatePackage(final String packageName) {
        progressContributor.progress(formatMessage(NbBundle.getMessage(ProgressDisplayer.class, "MSG_ScanningPackage"), packageName));
    }
    
    public static ProgressDisplayer getVisibleProgressDisplayer() {
        return instance;
    }
    
    public static boolean showProgress(JMManager model) {
        if (JMManager.SCAN_DEBUG) System.err.println("ProgressDisplayer: openProgressDialog"); // NOI18N
        instance = new ProgressDisplayer(model);
        instance.startResolution();
        return true;
    }

}
