/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.javacore;

import java.net.URL;
import java.util.Iterator;
import java.util.Set;
import javax.swing.SwingUtilities;
import org.netbeans.api.java.queries.SourceLevelQuery;
import org.netbeans.jmi.javamodel.Codebase;
import org.netbeans.jmi.javamodel.CodebaseClass;
import org.netbeans.jmi.javamodel.JavaModelPackage;
import org.netbeans.modules.javacore.classpath.MergedClassPathImplementation;
import org.netbeans.modules.javacore.internalapi.JavaMetamodel;
import org.netbeans.modules.javacore.scanning.FileScanner;
import org.openide.ErrorManager;
import org.openide.awt.StatusDisplayer;
import org.openide.filesystems.FileObject;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.actions.CallableSystemAction;

public class RescanAction extends CallableSystemAction implements Runnable {
    private RequestProcessor.Task scanningTask;
    private Runnable start;
    private Runnable stop;
    
    public String getName() {
        return NbBundle.getMessage(RescanAction.class, "LBL_RescanAction"); // NOI18N
    }
    
    public HelpCtx getHelpCtx() {
        return new HelpCtx(RescanAction.class);
    }
    
    public void performAction() {
        postRequest();
    }
    
    private void postRequest() {
        init();
        scanningTask.schedule(0);
    }
    
    private void init() {
        if (scanningTask == null) {
            scanningTask = new RequestProcessor("Rescanning RP").create(this);
            start = new Runnable() {
                public void run() {
                    StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(RescanAction.class, "LBL_Rescanning"));
                }
            };
            stop = new Runnable() {
                public void run() {
                    StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(RescanAction.class, "LBL_RescanningFinished"));
                }
            };
        }
    }
    
    protected boolean asynchronous() {
        return false;
    } 
    
    public void run() {
        Set roots = MergedClassPathImplementation.getDefault().getRoots();
        SwingUtilities.invokeLater(start);
        try {
            for (Iterator it = roots.iterator(); it.hasNext();) {
                FileObject root = (FileObject) it.next();

                JMManager.getDefaultRepository().beginTrans(false);
                try {
                    JavaModelPackage extent = JavaMetamodel.getManager().getJavaExtent(root);
                    if (extent != null) {
                        CodebaseClass cbClass = extent.getCodebase();
                        Codebase cb = (Codebase) cbClass.refAllOfClass().iterator().next();
                        try {
                            URL url = root.getURL();
                            String sourceLevel = SourceLevelQuery.getSourceLevel(root);
                            new FileScanner(url, sourceLevel, cb, true).scan();
                        } catch (Exception ex) {
                            ErrorManager.getDefault().notify(ex);
                        }
                    }
                } finally {
                    JavaMetamodel.getDefaultRepository().endTrans();
                }
            }
        } finally {
            SwingUtilities.invokeLater(stop);
        }
    }
}
