/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.javacore;
import javax.swing.JComponent;
import javax.swing.JDialog;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

/**
 *
 * @author  Jan Becicka
 */
public class ShutDownProgressPanel extends JDialog {
    
    private static ShutDownProgressPanel instance = null;

    private ProgressHandle progress;
    private int currentValue;
    private int maxValue;
    
    /** Creates new form UndoProgressPanel */
    private ShutDownProgressPanel() {
        //super(WindowManager.getDefault().getMainWindow(),true);
        setModal(true);
        initComponents();
        this.progress = ProgressHandleFactory.createHandle("");//NOI18N
        jPanel1.add(ProgressHandleFactory.createProgressComponent(progress), java.awt.BorderLayout.CENTER);
        pack();
        setBounds(Utilities.findCenterBounds(getSize()));
        //setLocationRelativeTo(WindowManager.getDefault().getMainWindow());
        setTitle(NbBundle.getMessage(ShutDownProgressPanel.class, "LBL_ShutDownTitle"));
    }
    
    public static synchronized ShutDownProgressPanel getDefault() {
        if (instance == null) {
            instance = new ShutDownProgressPanel();
        }
        return instance;
    }
    
    public void start(int value) {
        currentValue = 0;
        maxValue = value;
        progress.start(value);
    }
    
    public void step() {
        if (currentValue < maxValue) {
            progress.progress(currentValue++);
        }
    }
    
    public void stop() {
        progress.finish();
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc=" Generated Code ">//GEN-BEGIN:initComponents
    private void initComponents() {
        jPanel1 = new javax.swing.JPanel();
        label = new javax.swing.JLabel();

        setDefaultCloseOperation(javax.swing.WindowConstants.DO_NOTHING_ON_CLOSE);
        jPanel1.setLayout(new java.awt.BorderLayout());

        jPanel1.setBorder(javax.swing.BorderFactory.createEmptyBorder(12, 12, 11, 11));
        label.setText(java.util.ResourceBundle.getBundle("org/netbeans/modules/javacore/Bundle").getString("LBL_ShutDownProgressLabel"));
        label.setBorder(javax.swing.BorderFactory.createEmptyBorder(1, 1, 6, 1));
        jPanel1.add(label, java.awt.BorderLayout.NORTH);

        getContentPane().add(jPanel1, java.awt.BorderLayout.CENTER);

        pack();
    }
    // </editor-fold>//GEN-END:initComponents
        
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JPanel jPanel1;
    private javax.swing.JLabel label;
    // End of variables declaration//GEN-END:variables
    
}
