/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.javacore.internalapi;

import java.io.IOException;
import javax.swing.text.StyledDocument;
import org.netbeans.jmi.javamodel.Resource;
import org.netbeans.modules.javacore.FileGuardedResolver;
import org.netbeans.modules.javacore.jmiimpl.javamodel.ResourceImpl;
import org.openide.ErrorManager;
import org.openide.cookies.EditorCookie;
import org.openide.loaders.DataObject;
import org.openide.text.PositionBounds;

/**
 *
 * @author Jan Becicka
 */
public final class GuardedQuery {
    
    private static GuardedResolver fileResolver = null;
    private static GuardedResolver documentResolver = null;

    private GuardedQuery() {
    }
    
    public static boolean isSectionGuarded(Resource res, PositionBounds pos) {
        ResourceImpl resource = (ResourceImpl) res;
        DataObject dobj = JavaMetamodel.getManager().getDataObject(resource);
        EditorCookie editor = (EditorCookie) dobj.getCookie(EditorCookie.class);
        StyledDocument doc = null;
        if (editor != null) {
            doc = editor.getDocument();
            if (doc == null && resource.getParser().isFromDocument()) {
                try {
                    doc = editor.openDocument();
                } catch (IOException ex) {
                    throw (RuntimeException) ErrorManager.getDefault().annotate(new RuntimeException(), ex);
                }
            }
        }
        if (doc != null) {
            return getDocumentGuardedResolver().isSectionGuarded(resource, pos);
        } else {
            return getFileGuardedResolver().isSectionGuarded(resource, pos);
        }
    }
    
    private static GuardedResolver getDocumentGuardedResolver() {
        if (documentResolver == null)
            return getFileGuardedResolver();
        return documentResolver;
    }
    
    private static GuardedResolver getFileGuardedResolver() {
        return FileGuardedResolver.getDefault();
    }
    
    public static void setDocumentGuardedResolver(GuardedResolver resolver) {
        documentResolver = resolver;
    }
}
