/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.modules.javacore.jmiimpl.javamodel;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.jmi.model.Association;
import javax.jmi.reflect.RefAssociation;
import javax.jmi.reflect.RefObject;
import org.netbeans.api.mdr.events.AssociationEvent;
import org.netbeans.api.mdr.events.AttributeEvent;
import org.netbeans.jmi.javamodel.AnnotationType;
import org.netbeans.jmi.javamodel.Extends;
import org.netbeans.jmi.javamodel.IsOfAnnotationType;
import org.netbeans.jmi.javamodel.Type;
import org.netbeans.mdr.handlers.AttrListWrapper;
import org.netbeans.modules.javacore.internalapi.JavaModelUtil;
import org.netbeans.modules.javacore.parser.ASTProvider;
import org.netbeans.modules.javacore.parser.AnnotationInfo;
import org.netbeans.modules.javacore.parser.ElementInfo;
import org.netbeans.jmi.javamodel.Annotation;
import org.netbeans.jmi.javamodel.Element;
import org.netbeans.jmi.javamodel.JavaModelPackage;
import org.netbeans.jmi.javamodel.MultipartId;
import org.netbeans.jmi.javamodel.TypeReference;
import org.netbeans.lib.java.parser.ASTree;
import org.netbeans.lib.java.parser.ASTreeTypes;
import org.netbeans.mdr.storagemodel.StorableObject;
import org.netbeans.modules.javacore.parser.TypeRef;
import org.openide.util.Utilities;


/**
 * Represents an annotation usage.
 *
 * @author  Pavel Flaska
 * @author  Tomas Hurka
 */
public abstract class AnnotationImpl extends SemiPersistentElement implements Annotation {
    private static final ElementInfo DEFAULT_INFO = new AnnotationInfo(null, AnnotationInfo.ANNOTATION_TYPE, null, null);

    private LightAttrList attributeValues;
    private MultipartId typeName = null;
    private String typeRef = null;
    protected boolean elementsInited = false;

    /** Creates a new instance of AnnotationImpl */
    public AnnotationImpl(StorableObject s) {
        super(s);
    }

    protected void matchPersistent(ElementInfo newInfo) {
        super.matchPersistent(newInfo);
        
        AnnotationInfo info = (AnnotationInfo) newInfo;
        
        if (!isPersisted()) {
            setPersisted(true);
            persist();
            setTypeRef(info.type);
            persistChildren(getPersistentList("attributeValues", super_getAttributeValues()), info.values);
        } else {
            if (!Utilities.compareObjects(info.type, getTypeRef())) {
                Type type = resolveType(info.type);
                Type old = resolveType(getTypeRef());
                _setType(type);
                fireAssocChange("type",old ,type); //NOI18N
            }
            processMembers(getAttributeValues(), info.values);
        }
    }

    protected abstract List super_getAttributeValues();

    protected void matchElementInfo(ElementInfo newInfo) {
        super.matchElementInfo(newInfo);
        resetASTElements();
    }
    
    protected ElementInfo getDefaultInfo() {
        return DEFAULT_INFO;
    }
    
    protected void resetASTElements() {
        deleteChild(typeName);
        typeName = null;
        elementsInited = false;
    }
    
    protected void resetChildren() {
        super.resetChildren();
        if (attributeValues != null) attributeValues.setInnerList(getPersistentList("attributeValues", super_getAttributeValues()));
        if (childrenInited) {
            resetASTElements();
            initChildren();
        }
    }
    
    /**
     * Returns the value of reference type.
     * @return Value of reference type.
     */
    public AnnotationType getType() {
        Type type;
        
        checkUpToDate();
        type = resolveType(getTypeRef());
        if (type instanceof AnnotationType)
            return (AnnotationType)type;
        return null;
    }

    /**
     * Sets the value of reference type. See {@link #getType} for description
     * on the reference.
     * @param newValue New value to be set.
     */
    public void setType(AnnotationType newValue) {
        _setType(newValue);
    }

    private void _setType(Type newValue) {
        TypeRef tr = typeToTypeRef(newValue);
        MultipartId typeReference = null;
        if (!disableChanges) {
            typeReference = (MultipartId) typeRefToTypeReference(tr, 0);
        }
        fireTypeNameChange(typeReference);
        _setTypeName(typeReference, tr);
    }
    
    protected final void fireAssocChange(String endName, Object oldValue, Object newValue) {
        fireAssocChange(endName, oldValue, newValue, AssociationEvent.POSITION_NONE);
    }
    
    protected final void fireAssocChange(String endName, Object oldValue, Object newValue, int position) {
        IsOfAnnotationType source = ((JavaModelPackage) refImmediatePackage()).getIsOfAnnotationType();
        if (_getMdrStorage().eventsEnabled()) {
            AssociationEvent event = new AssociationEvent(
                source,
                AssociationEvent.EVENT_ASSOCIATION_SET,
                this,
                endName,
                (RefObject) oldValue, 
                (RefObject) newValue, 
                position
            );
            _getMdrStorage().getEventNotifier().ASSOCIATION.firePlannedChange(source, event);
        }
    }

    
    public MultipartId getTypeName() {
        checkUpToDate();
        if (!elementsInited) {
            initASTElements();
        }
        return typeName;
    }

    public void setTypeName(MultipartId typeName) {
        _setTypeName(typeName, typeReferenceToTypeRef(typeName, 0));
    }
    
    private void _setTypeName(MultipartId typeName, TypeRef typeRef) {
        if (!disableChanges) {
            objectChanged(CHANGED_TYPE);
            changeChild(getTypeName(), typeName);
            this.typeName = typeName;
        }
        setTypeRef(typeRef);
    }

    private void fireTypeNameChange(TypeReference typeReference) {
        Object oldValue = null;
        Object newValue = null;
        if (elementsInited && !disableChanges) {
            oldValue = getTypeName();
            newValue = typeReference;
        }
        fireAttrChange("typeName", oldValue, newValue); // NOI18N
    }

    public void replaceChild(Element oldElement, Element newElement) {
        if (childrenInited) {
            if (elementsInited) {
                if (oldElement.equals(typeName)) {
                    setTypeName((MultipartId) newElement);
                    return;
                }
            }
            if (replaceObject(getAttributeValues(), oldElement, newElement)) return;
        }
        super.replaceChild(oldElement, newElement);
    }

    public List getChildren() {
        List list = new ArrayList(getAttributeValues().size() + 1);
        addIfNotNull(list, getTypeName());
        list.addAll(getAttributeValues());
        return list;
    }

    public void fixImports(Element scope, Element original) {
        Annotation ann=(Annotation)original;
        AnnotationType type=ann.getType();
        if (type!=null) {
            setTypeName(JavaModelUtil.resolveImportsForClass(scope,type));         
        }
        fixImports(scope,getAttributeValues(),ann.getAttributeValues());
    }

    public List getInitedChildren() {
        if (childrenInited) {
            List list = new ArrayList(10);
            if (elementsInited) {
                addIfNotNull(list, typeName);
            }
            list.addAll(getAttributeValues());
            return list;
        }
        return Collections.EMPTY_LIST;
    }

    public List getAttributeValues() {
       checkUpToDate();
        if (attributeValues == null) {
            attributeValues = createChildrenList("attributeValues", (AttrListWrapper) super_getAttributeValues(), null, CHANGED_ANNOTATION);
        }
        return attributeValues;
    }
    
    String getRawText() {
        StringBuffer buf = new StringBuffer();
        buf.append('@').append(((MultipartIdImpl) getTypeName()).getSourceText());
        List attributes = getAttributeValues();
        if (!attributes.isEmpty()) {
            buf.append('(');
            Iterator aIt = attributes.iterator();
            buf.append(((AttributeValueImpl) aIt.next()).getSourceText());
            while (aIt.hasNext()) {
                formatElementPart(COMMA, buf);
                buf.append(((AttributeValueImpl) aIt.next()).getSourceText());
            }
            buf.append(')');
        };
        return buf.toString();
    }
    
    public void getDiff(List diffList) {
        ASTProvider parser = getParser();
        ASTree[] children = getASTree().getSubTrees();
        AnnotationInfo astInfo = (AnnotationInfo) getElementInfo();
        getChildDiff(diffList, parser, children[0], (MetadataElement) getTypeName(), CHANGED_TYPE);
        if (astInfo.values.length == 0) {
            if (isChanged(CHANGED_ANNOTATION)) {
                StringBuffer buf = new StringBuffer();
                Collection values = getAttributeValues();
                if (!values.isEmpty()) {
                    buf.append('(');
                    Iterator it = values.iterator();
                    while (it.hasNext()) {
                        buf.append(((AttributeValueImpl) it.next()).getSourceText());
                        if (it.hasNext()) {
                            formatElementPart(COMMA, buf);
                        }
                    }
                    buf.append(')');
                }
                int endOffset = getEndOffset(parser, children[0]);
                diffList.add(new DiffElement(endOffset, endOffset, buf.toString()));
            }
        } else if (getAttributeValues().isEmpty()) {
            if (isChanged(CHANGED_ANNOTATION)) {
                replaceNode(diffList, parser, children[1], "", 0, null);
            }
        } else {
            getCollectionDiff(diffList, parser, CHANGED_ANNOTATION, astInfo.values, getAttributeValues(), parser.getToken(children[1].getLastToken()).getStartOffset(), ", "); // NOI18N
        }
    }
    ////////////////////////////////////////////////////////////////////////////
    protected void initChildren() {
        childrenInited = false;
        AnnotationInfo info = (AnnotationInfo) getElementInfo();
        attributeValues = createChildrenList(attributeValues, "attributeValues", (AttrListWrapper) super_getAttributeValues(), info.values, CHANGED_ANNOTATION);
        childrenInited = true;
        
        if (elementsInited) {
            initASTElements();
        }
    }

    protected void initASTElements() {
        elementsInited = false;
        if (!childrenInited) {
            initChildren();
        }
        AnnotationInfo info = (AnnotationInfo) getElementInfo();
        ASTree tree = info.getTypeAST(this);
        typeName = (MultipartId) initOrCreate(typeName, tree);
        elementsInited = true;
    }
    
    protected void setData(MultipartId typeName, List attributeValues) {
        changeChild(null, typeName);
        this.typeName = typeName;
        setTypeRef(typeReferenceToTypeRef(typeName, 0));
        this.attributeValues = createChildrenList("attributeValues", (AttrListWrapper) super_getAttributeValues(), attributeValues, CHANGED_ANNOTATION); // NOI18N
        childrenInited = true;
        elementsInited = true;
    }
    
    protected void setTypeRef(TypeRef type) {
        _getDelegate().setSlot1(type);
    }
    
    public TypeRef getTypeRef() {
        return (TypeRef) _getDelegate().getSlot1();
    }
    
    public boolean isPersisted() {
        return _getDelegate().getSlot2() != null;
    }
    
    public void setPersisted(boolean persisted) {
        _getDelegate().setSlot2(persisted ? "" : null);
    }
    
    void childChanged(MetadataElement mpi) {
        super.childChanged(mpi);
        if (elementsInited) {
            if (mpi == typeName) {
                setTypeName((MultipartId) mpi);
            }
        }
    }
    
    protected void _delete() {
        if (elementsInited) {
            deleteChild(typeName);
        }
        deleteChildren("attributeValues", (AttrListWrapper) super_getAttributeValues());
        super._delete();
    }
    
    public Element duplicate(JavaModelPackage targetExtent) {
        return targetExtent.getAnnotation().createAnnotation(
                   (MultipartId) ((MetadataElement) getTypeName()).duplicate(targetExtent),
                   duplicateList(getAttributeValues(), targetExtent)
               );
    }
    
    public String getName() {
        throw new UnsupportedOperationException();
    }

    protected void matchName(ElementInfo info) {
    }
}
