/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.modules.javacore.jmiimpl.javamodel;

import java.util.List;
import org.netbeans.mdr.storagemodel.StorableClass;
import org.netbeans.jmi.javamodel.*;
import org.netbeans.mdr.handlers.ClassProxyHandler;
import org.netbeans.mdr.persistence.StorageException;
import org.netbeans.mdr.storagemodel.StorableBaseObject;
import org.netbeans.modules.javacore.ClassIndex;

/**
 *
 * @author  Pavel Flaska
 */
public abstract class AnnotationTypeClassImpl extends ClassProxyHandler implements AnnotationTypeClass {
    
    /** Creates a new instance of AnnotationTypeClassImpl */
    public AnnotationTypeClassImpl(StorableClass s) {
        super(s);
    }
    
    public AnnotationType createAnnotationType() {
        return create(null, null, 0, null, null, null, null, null, null);
    }
    
    public AnnotationType createAnnotationType(String name, 
                                               List annotations,
                                               int modifiers,
                                               String javadocText,
                                               JavaDoc javadoc,
                                               List contents,
                                               MultipartId superClassName,
                                               List interfaceNames,
                                               List typeParameters) 
    {
        return create(name, annotations, modifiers, javadocText, javadoc, contents, superClassName, interfaceNames, typeParameters);
    }
    
    protected abstract AnnotationType super_createAnnotationType();
    protected abstract AnnotationType super_createAnnotationType(String name, 
                                               List annotations,
                                               int modifiers,
                                               String javadocText,
                                               JavaDoc javadoc,
                                               List contents,
                                               MultipartId superClassName,
                                               List interfaceNames,
                                               List typeParameters);
    
    public Type resolve(String name) {
        if (name == null) return null; // throw new NullPointerException();
        
        _lock(false);
        try {
            JavaModelPackage pkg = (JavaModelPackage) refImmediatePackage();
            JavaClassClassImpl cls = (JavaClassClassImpl) pkg.getJavaClass();
            JavaClass result = cls.resolveClass(name, true);

            if (result == null || !(result instanceof AnnotationType)) {
                // annotation type was not found - create UnresolvedAnnotationType
                UnresolvedAnnotationTypeClassImpl ann=(UnresolvedAnnotationTypeClassImpl)pkg.getUnresolvedAnnotationType();
                result = ann.resolveUnresolved(name);
            }
            return result;
        } finally {
            _unlock();
        }
    }
    
    protected SemiPersistentElement createTransient() {
        try {
            StorableBaseObject s = _getDelegate();
            DeferredObject o = new DeferredObject(null, s.getMdrStorage(), s.getImmediatePackageId(), s.getOutermostPackageId(), s.getMetaObject(), (StorableClass) s, null, true);
            SemiPersistentElement result = (SemiPersistentElement) _getRepository().getHandler(o);
            return result;
        } catch (StorageException e) {
            throw new RuntimeException();
        }
    }
    
    public AnnotationTypeImpl create(String name, int modifiers, boolean isTransient) {
        AnnotationTypeImpl result;
        if (isTransient) {
            result = (AnnotationTypeImpl) createTransient();
            result.setName(name);
            result.setModifiers(modifiers);
        } else {
            result = (AnnotationTypeImpl) super_createAnnotationType(name, null, modifiers, null, null, null, null, null, null);
            if (name != null) {
                JavaModelPackage srcExtent = (JavaModelPackage) refOutermostPackage();
                ClassIndex index = ClassIndex.getIndex(srcExtent);
                index.addClass(result, name, result.getSimpleName());
            }
        }
        return result;
    }

    private AnnotationTypeImpl create(String name, 
                                      List annotations,
                                      int modifiers,
                                      String javadocText,
                                      JavaDoc javadoc,
                                      List contents,
                                      MultipartId superClassName,
                                      List interfaceNames,
                                      List typeParameters)
    {
        boolean fail = true;
        _lock(true);
        try {
            AnnotationTypeImpl result = create(name, modifiers, false);
            result.setNew();
            result.setData(annotations, javadocText, javadoc);
            fail = false;
            return result;
        } finally {
            _unlock(fail);
        }
    }
    
}
