/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.modules.javacore.jmiimpl.javamodel;

import java.lang.ref.WeakReference;
import java.util.*;
import javax.jmi.reflect.ConstraintViolationException;
import org.netbeans.jmi.javamodel.*;
import org.netbeans.lib.java.parser.ASTree;
import org.netbeans.mdr.storagemodel.StorableObject;
import org.netbeans.modules.javacore.parser.ASTProvider;
import org.netbeans.modules.javacore.parser.AnnotationTypeInfo;
import org.netbeans.modules.javacore.parser.ElementInfo;

/**
 *
 * @author  Pavel Flaska
 */
public abstract class AnnotationTypeImpl extends JavaClassImpl implements AnnotationType {

    static final ElementInfo DEFAULT_INFO = new AnnotationTypeInfo(null, AnnotationTypeInfo.ANNOTATIONTYPE_TYPE, null, 0, null, null);
    
    /** Creates a new instance of AnnotationTypeImpl */
    public AnnotationTypeImpl(StorableObject s) {
        super(s);
    }
    
    public boolean isInterface() {
        return true;
    }
    
    public void setInterface(boolean newValue) {
        if (newValue) {
            throw new UnsupportedOperationException("setInterface()");  // NOI18N
        }
    }
    
    public List getInterfaces() {
        TypeClass typeClass = ((JavaModelPackage) refImmediatePackage()).getType();
        return Collections.singletonList(typeClass.resolve("java.lang.annotation.Annotation")); // NOI18N
    }
    
    /**
     * Set superclass is not allowed for <tt>AnnotationType</tt> as the
     * superclass is always <tt>java.lang.annotation.Annotation</tt>.
     * Implemented only to override java class implementation.
     * 
     * @param newValue  for not null values, it throws ConstraintViolationException
     * @throws  ConstraintViolationException  if parameter is not <tt>null</tt> value
     */
    public void setSuperClass(JavaClass newValue) {
        if (newValue != null) {
            throw new ConstraintViolationException(null, null, "Cannot set superclass of annotation type."); // NOI18N
        }
    }
    
    public void setSuperClassName(MultipartId newValue) {
        if (newValue != null) {
            throw new ConstraintViolationException(null, null, "Cannot set superclass name of annotation type."); // NOI18N
        }
    }

    protected ElementInfo getDefaultInfo() {
        return DEFAULT_INFO;
    }
    
    public List getInterfaceNames() {
        return Collections.EMPTY_LIST;
    }
    
    protected ASTree getPartEndTree(ElementPartKind part) {
        if (ElementPartKindEnum.HEADER.equals(part)) {
            return getASTree().getSubTrees()[1];
        }
        return super.getPartEndTree(part);
    }

    public String getSourceText() {
        String origElem;
        if ((origElem = checkChange()) != null)
            return origElem;
        StringBuffer buf = new StringBuffer();
        buf.append('\n');
        generateNewJavaDoc(buf);
        buf.append(getIndentation());
        generateNewModifiers(buf);
        buf.append("@interface "); // NOI18N
        buf.append(getSimpleName());
        ClassDefinitionImpl.generateNewFeatures(this, buf, true);
        return buf.toString();
    }
    
    public void getDiff(List diffList) {
        AnnotationTypeInfo astInfo = (AnnotationTypeInfo) getElementInfo();
        ASTProvider parser = getParser();
        ASTree[] children = getASTree().getSubTrees();

        // javadoc print
        replaceJavaDoc(diffList);
        // print modifiers
        if (isChanged(CHANGED_MODIFIERS | CHANGED_ANNOTATION)) {
            diffModifiers(diffList, parser.getToken(children[1].getFirstToken() - 2), parser);
        } else if (children[0] != null) {
            getCollectionDiff(diffList, parser, CHANGED_ANNOTATION, astInfo.annotations, getAnnotations(), parser.getToken(children[0].getLastToken()).getEndOffset(), " "); // NOI18N
        }
        // print name
        if (isChanged(CHANGED_NAME)) {
            replaceNode(diffList, parser, children[1], getSimpleName(), 0, null);
        }
        getCollectionDiff(diffList, parser, CHANGED_FEATURES, astInfo.features, getContents(), getContentsEndOffset(parser, getASTree()), "\n"); // NOI18N
    }

    public Element duplicate(JavaModelPackage targetExtent) {
        return targetExtent.getAnnotationType().createAnnotationType(
                getName(),
                duplicateList(getAnnotations(), targetExtent),
                getModifiers(),
                null,
                (JavaDoc) duplicateElement(getJavadoc(), targetExtent),
                duplicateList(getContents(), targetExtent),
                (MultipartId) duplicateElement(getSuperClassName(), targetExtent),
                duplicateList(getInterfaceNames(), targetExtent),
                duplicateList(getTypeParameters(), targetExtent)
               );
    }

}
