/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.modules.javacore.jmiimpl.javamodel;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.netbeans.jmi.javamodel.ArgumentList;
import org.netbeans.jmi.javamodel.ArgumentListClass;
import org.netbeans.jmi.javamodel.Element;
import org.netbeans.jmi.javamodel.JavaModelPackage;
import org.netbeans.lib.java.parser.ASTree;
import org.netbeans.mdr.storagemodel.StorableObject;
import org.netbeans.modules.javacore.parser.ASTProvider;

/**
 *
 * @author Martin Matula
 */
public abstract class ArgumentListImpl extends TransientElement implements ArgumentList {
    private LightAttrList arguments;
    
    /** Creates a new instance of ArgumentListImpl */
    public ArgumentListImpl(StorableObject o) {
        super(o);
    }
    
    public List getArguments() {
        if (!childrenInited) {
            initChildren();
        }
        return arguments;
    }
    
    void setData(List arguments) {
        this.arguments = createChildrenList("arguments", arguments, CHANGED_ARGUMENTS); // NOI18N
    }        
    
    protected void _delete() {
        // --- delete components -------------------------------------------
        if (childrenInited) {
            deleteChildren(arguments);
        }
        // --- delete links -----------------------------------------------
        // no links to delete
        // --- call super ---------------------------------------
        super._delete();
    }
    
    public void replaceChild(Element oldElement, Element newElement) {
        if (childrenInited) {
            replaceObject(getArguments(), oldElement, newElement);
        }
    }

    public List getChildren() {
        return new ArrayList(getArguments());
    }
    
    protected void initChildren() {
        childrenInited = false;
        arguments = createChildrenList(arguments, "arguments", getASTree().getSubTrees(), CHANGED_ARGUMENTS, false); // NOI18N
        childrenInited = true;
    }
    
    public String getSourceText() {
        String origElem;
        if ((origElem = checkChange()) != null)
            return origElem;
        StringBuffer buf = new StringBuffer();
        List arguments = getArguments();        
        for (Iterator iter = arguments.iterator(); iter.hasNext();) {
            StatementImpl expr = (StatementImpl) iter.next();
            buf.append(expr.getSourceText());
            if (iter.hasNext()) {
                buf.append(", "); // NOI18N
            }
        }
        return buf.toString();
    }

    public void getDiff(List diff) {
        ASTProvider parser = getParser();
        ASTree tree = getASTree();
        ASTree[] children = tree.getSubTrees();
        if (children == null)
            children = new ASTree[0];
        int pos = parser.getToken(tree.getLastToken()).getStartOffset();
        getCollectionDiff(diff, parser, CHANGED_ARGUMENTS, children, getArguments(), pos, ", "); // NOI18N
    }
    
    public Element duplicate(JavaModelPackage targetExtent) {
        return targetExtent.getArgumentList().createArgumentList(duplicateList(getArguments(), targetExtent));
    }
}
