/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.modules.javacore.jmiimpl.javamodel;

import org.netbeans.jmi.javamodel.ArrayAccess;
import org.netbeans.jmi.javamodel.Expression;
import org.netbeans.jmi.javamodel.PrimaryExpression;
import org.netbeans.lib.java.parser.ASTree;
import org.netbeans.mdr.storagemodel.StorableObject;
import org.netbeans.modules.javacore.parser.ASTProvider;

import java.util.*;
import org.netbeans.jmi.javamodel.Element;
import org.netbeans.jmi.javamodel.JavaModelPackage;

/**
 *
 * @author  Martin Matula
 */
public abstract class ArrayAccessImpl extends ExpressionImpl implements ArrayAccess {
    private PrimaryExpression array = null;
    private Expression index = null;
    
    /** Creates a new instance of ArrayAccessImpl */
    public ArrayAccessImpl(StorableObject o) {
        super(o);
    }
    
    public void setArray(PrimaryExpression expression) {
        objectChanged(CHANGED_ARRAY);
        changeChild(getArray(), expression);
        this.array = expression;
    }
    
    public PrimaryExpression getArray() {
        if (!childrenInited) {
            initChildren();
        }
        return array;
    }
    
    public void setIndex(Expression expression) {
        objectChanged(CHANGED_INDEX);
        changeChild(getIndex(), expression);
        this.index = expression;
    }
    
    public Expression getIndex() {
        if (!childrenInited) {
            initChildren();
        }
        return index;
    }
    
    public List getChildren() {
        List list = new ArrayList();
        addIfNotNull(list, getArray()); 
        addIfNotNull(list, getIndex()); 
        return list;
    }
    
    protected void initChildren() {
        childrenInited = false;
        ASTree tree = getASTree();
        if (tree != null) {
            ASTree[] parts = tree.getSubTrees();
            array = (PrimaryExpression) initOrCreate(array, parts[0]);
            index = (Expression) initOrCreate(index, parts[1]);
        }
        childrenInited = true;
    }
    
    public String getSourceText() {
        String origElem;
        if ((origElem = checkChange()) != null)
            return origElem;
        StringBuffer buf = new StringBuffer();
        StatementImpl array = (StatementImpl) getArray();
        StatementImpl index = (StatementImpl) getIndex();
        buf.append(array.getSourceText());
        formatElementPart(ARRAY_OPEN_BRACKET, buf);
        buf.append(index.getSourceText());
        formatElementPart(ARRAY_CLOSE_BRACKET, buf);
        return buf.toString();
    }
    
    public void getDiff(List diff) {
        ASTProvider parser = getParser();
        ASTree[] children = getASTree().getSubTrees();
        getChildDiff(diff, parser, children[0], (StatementImpl) getArray(), CHANGED_ARRAY);
        getChildDiff(diff, parser, children[1], (StatementImpl) getIndex(), CHANGED_INDEX);
    }
    
    void setData(PrimaryExpression array, Expression index) {
        changeChild(null, array);
        this.array = array;
        changeChild(null, index);
        this.index = index;
    }
    
    protected void _delete() {
        // --- delete components -------------------------------------------
        if (childrenInited) {
            deleteChild(array);
            deleteChild(index);
        }
        // --- delete links -----------------------------------------------
        // no links to delete
        // --- call super ---------------------------------------
        super._delete();
    }
    
    public void replaceChild(Element oldElement,Element newElement) {
        if (childrenInited) {
            if (oldElement.equals(array)) {
                setArray((PrimaryExpression)newElement);
            } else if (oldElement.equals(index)) {
                setIndex((Expression)newElement);
            }
        }
    }
    
    public Element duplicate(JavaModelPackage targetExtent) {
        return targetExtent.getArrayAccess().createArrayAccess(
                (PrimaryExpression) duplicateElement(getArray(), targetExtent),
                (Expression) duplicateElement(getIndex(), targetExtent)
               );
    }
}
