/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.modules.javacore.jmiimpl.javamodel;

import java.util.Collection;
import java.util.Collections;
import javax.jmi.reflect.ConstraintViolationException;
import org.netbeans.jmi.javamodel.*;
import org.netbeans.mdr.handlers.ClassProxyHandler;
import org.netbeans.mdr.persistence.MOFID;
import org.netbeans.mdr.persistence.StorageException;
import org.netbeans.mdr.storagemodel.StorableBaseObject;
import org.netbeans.mdr.storagemodel.StorableClass;
import org.netbeans.mdr.util.DebugException;

/**
 *
 * @author Martin Matula
 */
public abstract class ArrayClassImpl extends ClassProxyHandler implements ArrayClass {
    private static final String MOFID_PREFIX = "array:"; // NOI18N
    private static final InstanceMap allInstances = new InstanceMap();
    
    public ArrayClassImpl(StorableClass s) {
        super(s);
    }
    
    public Array createArray() {
        throw new ConstraintViolationException(this, refMetaObject(), "Cannot create instance of Array directly - use resolveArray instead."); // NOI18N
    }
    
    public Array createArray(String name, java.util.List contents, org.netbeans.jmi.javamodel.MultipartId superClassName, java.util.List interfaceNames) {
        throw new ConstraintViolationException(this, refMetaObject(), "Cannot create instance of Array directly - use resolveArray instead."); // NOI18N
    }
    
    public Array resolveArray(Type type) {
        if (type == null) return null;
        _lock(false);
        try {
            ArrayImpl result = (ArrayImpl) allInstances.get(type);
            if (result == null) {
                try {
                    // [TODO] better unify immediate package and class proxy
                    StorableBaseObject s = _getDelegate();
                    MOFID mofId = new MOFID(type.hashCode(), MOFID_PREFIX + type.refMofId());
                    DeferredObject o = new DeferredObject(mofId, s.getMdrStorage(), s.getImmediatePackageId(), s.getOutermostPackageId(), s.getMetaObject(), (StorableClass) s, null);
                    result = (ArrayImpl) _getRepository().getHandler(o);
                    result.type = type;
                    allInstances.put(type, result);
                } catch (StorageException e) {
                    throw new DebugException();
                }
            }
            return result;
        } finally {
            _unlock();
        }
    }
    
    public org.netbeans.jmi.javamodel.Type resolve(java.lang.String name) {
        JavaModelPackage pkg = (JavaModelPackage) refImmediatePackage();
        return pkg.getType().resolve(name);
    }

    protected Collection _allOfClass(boolean recursive) {
        return Collections.unmodifiableCollection(allInstances.values());
    }
}
