/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.modules.javacore.jmiimpl.javamodel;

import java.util.*;
import javax.jmi.model.MofClass;
import javax.jmi.model.NameNotFoundException;
import javax.jmi.reflect.ConstraintViolationException;
import javax.jmi.reflect.RefObject;
import org.netbeans.jmi.javamodel.*;
import org.netbeans.mdr.handlers.InstanceHandler;
import org.netbeans.mdr.storagemodel.StorableObject;

/**
 *
 * @author  Martin Matula
 */
public abstract class ArrayImpl extends InstanceHandler implements Array {
    Type type = null;
    String name = null;
    private Field lengthField = null;
    private Method cloneMethod = null;

    public ArrayImpl(StorableObject s) {
        super(s);
    }
    
    public Type getType() {
        return type;
    }
    
    public String getName() {
        if (name == null) {
            name = getType().getName() + "[]"; // NOI18N
        }
        return name;
    }
    
    public void setName() {
        throwIsReadOnly(this, "name"); // NOI18N
    }
    
    public void setType(Type type) {
        throwIsReadOnly(this, "type"); // NOI18N
    }
    
    private Field getSyntheticField() {
        if (lengthField == null) {
            lengthField = new ArrayLengthField(this);
        }
        return lengthField;
    }
    
    private Method getSyntheticMethod() {
        if (cloneMethod == null) {
            cloneMethod = new ArrayCloneMethod(this);
        }
        return cloneMethod;
    }

    // ClassDefinition implementation ...........................................
    
    public Field getField(String name, boolean includeSupertypes) {
        return "length".equals(name) ? getSyntheticField() : null; // NOI18N
    }
    
    public Method getMethod(String name, List parameters, boolean includeSupertypes) {
        return "clone".equals(name) ? getSyntheticMethod() : null; // NOI18N
    }
    
    public JavaClass getInnerClass(String simpleName, boolean includeSupertypes) {
        return null;
    }
    
    public Constructor getConstructor(java.util.List parameters, boolean includeSupertypes) {
        return null;
    }
    
    public List getContents() {
        return getFeatures();
    }
    
    public MultipartId getSuperClassName() {
        return null;
    }
    
    public void setSuperClassName(MultipartId newValue) {
        throwIsReadOnly(this, "superClassName"); // NOI18N
    }
    
    public List getInterfaceNames() {
        return Collections.EMPTY_LIST;
    }
    
    public List getFeatures() {
        List ret = new ArrayList(2);
        ret.add(getSyntheticField());
        ret.add(getSyntheticMethod());
        return ret;
    }
    
    public List getInterfaces() {
        List ret = new ArrayList(2);
        ret.add(((JavaModelPackage) refImmediatePackage()).getType().resolve("java.lang.Cloneable")); // NOI18N);
        ret.add(((JavaModelPackage) refImmediatePackage()).getType().resolve("java.io.Serializable")); // NOI18N);
        return ret;
    }
    
    public JavaClass getSuperClass() {
        return (JavaClass)((JavaModelPackage) refImmediatePackage()).getType().resolve("java.lang.Object"); // NOI18N
    }
    
    public void setSuperClass(JavaClass newValue) {
        throwIsReadOnly(this, "superClass"); // NOI18N
    }
    
    public boolean isSubTypeOf(ClassDefinition clazz) {
        return ClassDefinitionImpl.isSubTypeOf(this, clazz);
    }
    
    public Resource getResource() {
        return null;
    }
    
    public List getChildren() {
        return new ArrayList(getContents());
    }
    
    public int getStartOffset() {
        throw new UnsupportedOperationException();
    }
    
    public int getEndOffset() {
        throw new UnsupportedOperationException();
    }
    
    public int getPartStartOffset(ElementPartKind part) {
        throw new UnsupportedOperationException();
    }

    public int getPartEndOffset(ElementPartKind part) {
        throw new UnsupportedOperationException();
    }
    
    public boolean isValid() {
        return type.isValid();
    }
    
    public void replaceChild(Element oldChild, Element newChild) {
        throw new UnsupportedOperationException();
    }

    // helper methods ...........................................................
    
    static void throwIsReadOnly(RefObject obj, String attrName) {
        RefObject attr = null;
        try {
            attr = ((MofClass) obj.refMetaObject()).lookupElementExtended(attrName);
        } catch (NameNotFoundException e) {
            // ignore
        }
        attrName = attrName.substring(0, 1).toUpperCase() + attrName.substring(1);
        throw new ConstraintViolationException(obj, attr, attrName + " is readonly."); // NOI18N
    }
    
    static void throwIsReadOnly(RefObject obj) {        
        throw new ConstraintViolationException(obj, null, "This instance is read only."); // NOI18N
    }

    public Element duplicate() {
        throw new UnsupportedOperationException("The operation is intentionally unsupported at this element."); // NOI18N 
    }
}
