/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.modules.javacore.jmiimpl.javamodel;

import java.util.*;
import javax.jmi.reflect.RefFeatured;
import org.netbeans.jmi.javamodel.ArrayInitialization;
import org.netbeans.jmi.javamodel.AttributeValue;
import org.netbeans.jmi.javamodel.Element;
import org.netbeans.jmi.javamodel.JavaModelPackage;
import org.netbeans.lib.java.parser.ASTree;
import org.netbeans.lib.java.parser.ASTreeTypes;
import org.netbeans.mdr.storagemodel.StorableObject;
import org.netbeans.modules.javacore.parser.ASTProvider;
import org.netbeans.modules.javacore.parser.AnnotationInfo;
import org.netbeans.modules.javacore.parser.AnnotationValueInfo;

/**
 *
 * @author  Martin Matula
 */
public abstract class ArrayInitializationImpl extends TransientElement implements ArrayInitialization {
    private LightAttrList elementValues = null;
    
    /** Creates a new instance of ArrayInitializationImpl */
    public ArrayInitializationImpl(StorableObject o) {
        super(o);
    }
    
    public List getElementValues() {
        if (!childrenInited) {
            initChildren();
        }
        return elementValues;
    }
    
    public List getChildren() {
        return new ArrayList(getElementValues());
    }
    
    protected void initChildren() {
        childrenInited = false;
        ASTree tree = getASTree();
        if (tree != null) {
            ASTree[] parts = tree.getSubTrees();
            elementValues = createChildrenList(elementValues, "elementValues", parts[0], ASTreeTypes.VARIABLE_INITIALIZERS, CHANGED_ELEMENT_VALUES, false); // NOI18N
        }
        childrenInited = true;
    }
    
    protected MetadataElement createElement(ASTree tree) {
        if (tree == null) return null;
        if (tree.getType() == ASTreeTypes.ANNOTATION) {
            RefFeatured parent = refImmediateComposite();
            if (parent instanceof AttributeValueImpl) {
                AttributeValueImpl attrVal = (AttributeValueImpl)parent;
                AnnotationValueInfo info = (AnnotationValueInfo) attrVal.getElementInfo();
                Object[] arrEls = (Object[])info.value;
                
                for (int i=0;i<arrEls.length;i++) {
                    Object el=arrEls[i];
                    
                    if (el instanceof AnnotationInfo) {
                        AnnotationInfo annInfo = (AnnotationInfo) el;
                        Object infoTree = annInfo.getASTree().get();
                        if (infoTree == null) {
                            infoTree = annInfo.refreshASTree();
                        }
                        if (infoTree == tree) {
                            return createElement(annInfo);
                        }
                    }
                }
                throw new IllegalArgumentException("Annotation tree not found; resource: " + getResource().getName()); // NOI18N
            }
        }
        return super.createElement(tree);
    }

    public String getRawText() {
        StringBuffer buf = new StringBuffer();
        List values = getElementValues();
        formatElementPart(ARRAY_OPEN_CURLY, buf);
        boolean isAttributeValue = refImmediateComposite() instanceof AttributeValue;
        MetadataElement composite = (MetadataElement) refImmediateComposite();
        if (isAttributeValue) {
            buf.append('\n');
            buf.append(composite.getIndentation());
        }
        Iterator iter = values.iterator();
        while (iter.hasNext()) {
            MetadataElement val = (MetadataElement) iter.next();
            buf.append(val.getSourceText());
            if (iter.hasNext()) {
                if (isAttributeValue) {
                    buf.append(",\n");
                    buf.append(composite.getIndentation());
                } else {
                    formatElementPart(COMMA, buf);
                }
            }
        }
        if (isAttributeValue) {
            buf.append('\n');
            buf.append(((MetadataElement) composite.refImmediateComposite()).getIndentation());
        }
        formatElementPart(ARRAY_CLOSE_CURLY, buf);
        return buf.toString();
    }
    
    public void getDiff(List diff) {
        ASTProvider parser = getParser();
        ASTree tree = getASTree();
        ASTree[] children = tree.getSubTrees();

        getCollectionDiff(diff, parser, CHANGED_ELEMENT_VALUES, children[0], ASTreeTypes.VARIABLE_INITIALIZERS, getElementValues(), parser.getToken(tree.getLastToken()).getStartOffset(), formatElementPart(COMMA));
    }
    
    void setData(List elementValues) {
        this.elementValues = createChildrenList("elementValues", elementValues, CHANGED_ELEMENT_VALUES); // NOI18N
    }
    
    protected void _delete() {
        // --- delete components -------------------------------------------
        if (childrenInited) {
            deleteChildren(elementValues);
        }
        // --- delete links -----------------------------------------------
        // no links to delete
        // --- call super ---------------------------------------
        super._delete();
    }
    
    public void replaceChild(Element oldElement,Element newElement) {
        if (childrenInited) {
            replaceObject(getElementValues(),oldElement,newElement);
        }
    }
    
    public Element duplicate(JavaModelPackage targetExtent) {
        return targetExtent.getArrayInitialization().createArrayInitialization(
                duplicateList(getElementValues(), targetExtent));
    }
}
