/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.javacore.jmiimpl.javamodel;

import java.lang.reflect.Modifier;
import java.util.*;
import javax.jmi.reflect.*;
import javax.jmi.model.MofClass;
import javax.jmi.model.Attribute;
import javax.jmi.model.GeneralizableElement;
import javax.jmi.model.NameNotFoundException;
import org.netbeans.jmi.javamodel.*;

/**
 * @author  Daniel Prusa
 */
public class ArrayLengthField implements Field {
    
    private static final String typeName = "int"; // NOI18N
    private static final String MOF_ID_PREFIX = "ArrayLengthField:"; // NOI18N
    
    private ArrayImpl parent;
    private String mofId;
    
    private Type type;
    private MultipartId typeRef;
    
    ArrayLengthField(ArrayImpl parent) {
        this.parent = parent;
        mofId = MOF_ID_PREFIX + parent.refMofId();
        type = ((JavaModelPackage) parent.refImmediatePackage()).getType().resolve(typeName);
        typeRef = new SyntheticMultipartId(this);
    }
    
    public List getAnnotations() {
        return Collections.EMPTY_LIST;
    }
    
    public ClassDefinition getDeclaringClass() {
        return parent;
    }
    
    public int getDimCount() {
        return 0;
    }
    
    public int getEndOffset() {
        return 0;
    }
    
    public boolean isDeprecated() {
        return false;
    }
    
    public InitialValue getInitialValue() {
        return null;
    }
    
    public String getInitialValueText() {
        return null;
    }
    
    public JavaDoc getJavadoc() {
        return null;
    }
    
    public String getJavadocText() {
        return null;
    }
    
    public int getModifiers() {
        return Modifier.PUBLIC | Modifier.FINAL;
    }
    
    public String getName() {
        return "length"; // NOI18N
    }
    
    public int getPartEndOffset(ElementPartKind part) {
        return 0;
    }
    
    public int getPartStartOffset(ElementPartKind part) {
        return 0;
    }
    
    public Resource getResource() {
        return parent.getResource();
    }
    
    public int getStartOffset() {
        return 0;
    }
    
    public Type getType() {
        return type;
    }
    
    public TypeReference getTypeName() {
        return typeRef;
    }

    public List getChildren() {
        return Collections.EMPTY_LIST;
    }

    public boolean isValid() {
        return true;
    }

    public Collection getReferences() {
        return Collections.EMPTY_LIST; // [TODO]
    }
    
    public boolean isFinal() {
        return true;
    }
    
    public RefClass refClass() {
        return ((JavaModelPackage) parent.refImmediatePackage()).getField();
    }
    
    public void refDelete() {
        // do nothing
    }
    
    public Object refGetValue(RefObject refObject) {
        if (!(refObject instanceof Attribute)) {
            throw new InvalidCallException(null, refObject);
        }
        return refGetValue(((Attribute) refObject).getName());
    }
    
    public Object refGetValue(String str) {
        if ("dimCount".equals(str)) { // NOI18N
            return new Integer(getDimCount());
        } else if ("final".equals(str)) { // NOI18N
            return isFinal() ? Boolean.TRUE : Boolean.FALSE;
        } else if ("initialValue".equals(str)) { // NOI18N
            return getInitialValue();
        } else if ("initialValueText".equals(str)) { // NOI18N
            return getInitialValueText();
        } else if ("javadoc".equals(str)) { // NOI18N
            return getJavadoc();
        } else if ("javadocText".equals(str)) { // NOI18N
            return getJavadocText();
        } else if ("modifiers".equals(str)) { // NOI18N
            return new Integer(getModifiers());
        } else if ("name".equals(str)) { // NOI18N
            return getName();
        } else if ("type".equals(str)) { // NOI18N
            return getType();
        } else if ("typeName".equals(str)) { // NOI18N
            return getTypeName();
        }
        throw new InvalidCallException(null, null, "Invalid attribute name: " + str); // NOI18N
    }
    
    public RefFeatured refImmediateComposite() {
        return parent;
    }
    
    public RefPackage refImmediatePackage() {
        return parent.refImmediatePackage();
    }
    
    public Object refInvokeOperation(RefObject refObject, List list) throws RefException {
        throw new InvalidCallException(null, null);
    }
    
    public Object refInvokeOperation(String str, List list) throws RefException {
        throw new InvalidCallException(null, null);
    }
    
    public boolean refIsInstanceOf(RefObject objType, boolean considerSubtypes) {
        GeneralizableElement metaObject = (GeneralizableElement) refMetaObject();
        return isInstanceOf(metaObject, objType, considerSubtypes);
    }
    
    private boolean isInstanceOf(GeneralizableElement metaObject, RefObject objType, boolean considerSubtypes) {
        if (metaObject.equals(objType))
            return true;
        if (considerSubtypes) {
            Iterator it = metaObject.getSupertypes().iterator();
            while (it.hasNext()) {
                if (isInstanceOf(((GeneralizableElement) it.next()), objType, true)) {
                    return true;
                }
            }
        }
        return false;
    }
    
    public RefObject refMetaObject() {
        return refClass().refMetaObject();
    }
    
    public String refMofId() {
        return mofId;
    }
    
    public RefFeatured refOutermostComposite() {
        return parent.refOutermostComposite();
    }
    
    public RefPackage refOutermostPackage() {
        return parent.refOutermostPackage();
    }
    
    public void refSetValue(String str, Object obj) {
        ArrayImpl.throwIsReadOnly(this);
    }
    
    public void refSetValue(RefObject refObject, Object obj) {
        ArrayImpl.throwIsReadOnly(this);
    }
    
    public Collection refVerifyConstraints(boolean param) {
        return Collections.EMPTY_LIST;
    }
    
    public void replaceChild(Element oldChild, Element newChild) {
        ArrayImpl.throwIsReadOnly(this);
    }
    
    public void setDimCount(int newValue) {
        ArrayImpl.throwIsReadOnly(this, "dimCount"); // NOI18N
    }
    
    public void setFinal(boolean newValue) {
        ArrayImpl.throwIsReadOnly(this, "final"); // NOI18N
    }
    
    public void setInitialValue(InitialValue newValue) {
        ArrayImpl.throwIsReadOnly(this, "initialValue"); // NOI18N
    }
    
    public void setInitialValueText(String newValue) {
        ArrayImpl.throwIsReadOnly(this, "initialValueText"); // NOI18N
    }
    
    public void setJavadoc(JavaDoc newValue) {
        ArrayImpl.throwIsReadOnly(this, "javadoc"); // NOI18N
    }
    
    public void setJavadocText(String newValue) {
        ArrayImpl.throwIsReadOnly(this, "javadocText"); // NOI18N
    }
    
    public void setModifiers(int newValue) {
        ArrayImpl.throwIsReadOnly(this, "modifiers"); // NOI18N
    }
    
    public void setName(String newValue) {
        ArrayImpl.throwIsReadOnly(this, "name"); // NOI18N
    }
    
    public void setType(Type newValue) {
        ArrayImpl.throwIsReadOnly(this, "type"); // NOI18N
    }
    
    public void setTypeName(TypeReference newValue) {
        ArrayImpl.throwIsReadOnly(this, "typeName"); // NOI18N
    }
        
    public Element duplicate() {
        throw new UnsupportedOperationException();
    }    
    
    public void setDeprecated(boolean newValue) {
        ArrayImpl.throwIsReadOnly(this, "typeName"); // NOI18N
    }
}
