/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.modules.javacore.jmiimpl.javamodel;

import org.netbeans.jmi.javamodel.ArrayReference;
import org.netbeans.jmi.javamodel.MultipartId;
import org.netbeans.jmi.javamodel.NamedElement;
import org.netbeans.lib.java.parser.ASTree;
import org.netbeans.mdr.storagemodel.StorableObject;

import java.util.List;
import org.netbeans.jmi.javamodel.Element;
import org.netbeans.jmi.javamodel.JavaModelPackage;

/**
 *
 * @author  Martin Matula
 */
public abstract class ArrayReferenceImpl extends TypeReferenceImpl implements ArrayReference {
    private int dimCount;

    /** Creates a new instance of MultipartIdImpl */
    public ArrayReferenceImpl(StorableObject o) {
        super(o);
    }
    
    protected ASTree getNameAST() {
        return getASTree();
    }

    public String getName() {
        StringBuffer buf = new StringBuffer();
        buf.append(getParent().getName());
        appendDims(buf);
        return buf.toString();
    }
    
    void setData(String name, MultipartId parent, int dimCount) {
        super.setData(name, parent);
        this.dimCount = dimCount;
    }

    public String getSourceText() {
        String origElem;
        if ((origElem = checkChange()) != null)
            return origElem;
        StringBuffer buf = new StringBuffer();
        buf.append(((MetadataElement) getParent()).getSourceText());
        appendDims(buf);
        return buf.toString();
    }

    public void setDimCount(int dimCount) {
        objectChanged(CHANGED_DIM_COUNT);
        this.dimCount = dimCount;
    }

    public int getDimCount() {
        if (isChanged(CHANGED_DIM_COUNT)) {
            return dimCount;
        } else {
            ASTree dimsTree = getASTree().getSubTrees()[1];
            return (dimsTree.getLastToken() - dimsTree.getFirstToken() + 1) / 2;
        }
    }

    private StringBuffer appendDims(StringBuffer buf) {
        for (int i = 0; i < getDimCount(); i++) {
            formatElementPart(ARRAY_OPEN_BRACKET, buf);
            formatElementPart(ARRAY_CLOSE_BRACKET, buf);
        }
        return buf;
    }

    public void getDiff(List diff) {
        ASTree tree = getASTree();
        getChildDiff(diff, getParser(), tree.getSubTrees()[0], (MetadataElement) getParent(), CHANGED_PARENT);
        if (isChanged(CHANGED_DIM_COUNT)) {
            replaceNode(diff, getParser(), tree.getSubTrees()[1], appendDims(new StringBuffer()).toString(), 0, null);
        }
    }
    
    public NamedElement getElement() {
        return (NamedElement) getParser().getSemanticInfo(getASTree(), this);
    }
    
    /**
     * Creates copy of the ArrayReference instance
     */
    public Element duplicate(JavaModelPackage targetExtent) {
        return targetExtent.getArrayReference().createArrayReference(
            getName(),
            (MultipartId) duplicateElement(getParent(), targetExtent),
            getDimCount()
        );
    }
}
