/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.modules.javacore.jmiimpl.javamodel;

import java.util.*;
import org.netbeans.jmi.javamodel.Case;
import org.netbeans.jmi.javamodel.Element;
import org.netbeans.jmi.javamodel.Expression;
import org.netbeans.jmi.javamodel.JavaModelPackage;
import org.netbeans.lib.java.parser.ASTree;
import org.netbeans.lib.java.parser.ASTreeTypes;
import org.netbeans.mdr.storagemodel.StorableObject;
import org.netbeans.modules.javacore.parser.ASTProvider;

/**
 *
 * @author  Martin Matula
 */
public abstract class CaseImpl extends TransientElement implements Case {
    private Expression value = null;
    private LightAttrList statements = null;
    
    /** Creates a new instance of CaseImpl */
    public CaseImpl(StorableObject o) {
        super(o);
    }
    
    public Expression getValue() {
        if (!childrenInited) {
            initChildren();
        }
        return value;
    }
    
    public void setValue(Expression value) {
        objectChanged(CHANGED_VALUE);
        changeChild(getValue(), value);
        this.value = value;
    }
    
    public List getStatements() {
        if (!childrenInited) {
            initChildren();
        }
        return statements;
    }
    
    public List getChildren() {
        List list = new ArrayList(1 + getStatements().size());
        addIfNotNull(list, getValue()); 
        list.addAll(getStatements()); 
        return list;
    }
    
    protected void initChildren() {
        childrenInited = false;
        ASTree tree = getASTree();
        if (tree != null) {
            value = (Expression) initOrCreate(value, getLabelAST(tree));
            statements = createChildrenList(statements, "statements", getStatementsAST(tree), CHANGED_STATEMENTS, false); // NOI18N
        }
        childrenInited = true;
    }
    
    private static ASTree getLabelAST(ASTree tree) {
        if (tree.getType() == ASTreeTypes.SWITCH_BLOCK_STATEMENT_GROUP) {
            ASTree[] cases = tree.getSubTrees();
            ASTree[] labels = cases[0].getSubTrees();
            return cases[0].getType() == ASTreeTypes.SWITCH_LABELS ? 
                labels[labels.length - 1].getSubTrees()[0] : labels[0];
        } else {
            return tree.getSubTrees()[0];
        }
    }        
    
    private static ASTree[] getStatementsAST(ASTree tree) {
        if (tree.getType() == ASTreeTypes.SWITCH_BLOCK_STATEMENT_GROUP) {
            return tree.getSubTrees()[1].getSubTrees();
        } else {
            return null;
        }
    }
    
    public String getSourceText() {
//        String origElem;
//        if ((origElem = checkChange()) != null)
//            return origElem;
        StringBuffer buf = new StringBuffer();
        List statements = getStatements();
        TransientElement value = (TransientElement)getValue();
        buf.append('\n');
        if (value != null) {
            formatElementPart(CASE_KEYWORD, buf);
            buf.append(value.getSourceText());
        } else {
            formatElementPart(DEFAULT_KEYWORD, buf);
        }
        buf.append(':');
        for (Iterator iter = statements.iterator(); iter.hasNext();) {
            buf.append('\n');
            StatementImpl stat = (StatementImpl) iter.next();
            buf.append(stat.getSourceText());
        }
        return buf.toString();
    }
     
    public void getDiff(List diff) {
        ASTProvider parser = getParser();
        ASTree tree = getASTree();

        getChildDiff(diff, parser, getLabelAST(tree), (MetadataElement) getValue(), CHANGED_VALUE);
        getCollectionDiff(diff, parser, CHANGED_STATEMENTS, getStatementsAST(tree), getStatements(), getEndOffset(parser, tree), "\n"); // NOI18N
    }
    
    void setData(Expression value, List statements) {
        // value
        changeChild(null, value);
        this.value = value;
        // statements
        this.statements = createChildrenList("statements", statements, CHANGED_STATEMENTS); // NOI18N
    }
    
    protected void _delete() {
        // --- delete components -------------------------------------------
        if (childrenInited) {
            deleteChild(value);
            deleteChildren(statements);
        }
        // --- delete links -----------------------------------------------
        // no links to delete
        // --- call super ---------------------------------------
        super._delete();
    }
    
    public void replaceChild(Element oldElement,Element newElement){
        if (childrenInited) {
            if (oldElement.equals(value)) {
                setValue((Expression)newElement);
            } else
                replaceObject(getStatements(),oldElement,newElement);
        }
    }
    
    public Element duplicate(JavaModelPackage targetExtent) {
        return targetExtent.getCase().createCase(
                (Expression) duplicateElement(getValue(), targetExtent), duplicateList(getStatements(), targetExtent));
    }
}
