/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
/*
 * ClassDefinitionClassImpl.java
 *
 * Created on 15 December 2003, 11:55
 */

package org.netbeans.modules.javacore.jmiimpl.javamodel;

import java.util.List;
import org.netbeans.jmi.javamodel.ClassDefinition;
import org.netbeans.jmi.javamodel.ClassDefinitionClass;
import org.netbeans.jmi.javamodel.JavaModelPackage;
import org.netbeans.jmi.javamodel.MultipartId;
import org.netbeans.mdr.storagemodel.StorableClass;

/**
 *
 * @author  Martin Matula
 */
public abstract class ClassDefinitionClassImpl extends SemiPersistentClass implements ClassDefinitionClass {
    
    /** Creates a new instance of ClassDefinitionClassImpl */
    public ClassDefinitionClassImpl(StorableClass s) {
        super(s);
    }
    
    public ClassDefinition createClassDefinition(String name, List contents, MultipartId superClassName, List interfaceNames){
        ClassDefinitionImpl result = create(contents);
        result.setSuperClassName(superClassName);
        result.getInterfaceNames().addAll(interfaceNames);
        result.setName(name);
        return result;
    }
    
    public ClassDefinition createClassDefinition() {
        return create(null);
    }
    
    private ClassDefinitionImpl create(List features) {
        ClassDefinitionImpl result = create();
        result.setNew();
        result.setData(features);
        return result;
    }

    ClassDefinitionImpl create() {
        return (ClassDefinitionImpl) createTransient();
    }
    
    public org.netbeans.jmi.javamodel.Type resolve(java.lang.String name) {
        JavaModelPackage pkg = (JavaModelPackage) refImmediatePackage();
        return pkg.getType().resolve(name);
    }
}
