/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *   
 *  You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *    
 *  The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 *  Microsystems, Inc. All Rights Reserved.
 *  
 */

package org.netbeans.modules.javacore.jmiimpl.javamodel;

import org.netbeans.jmi.javamodel.*;
import org.netbeans.lib.java.parser.ASTree;
import org.netbeans.lib.java.parser.ASTreeTypes;
import org.netbeans.lib.java.parser.Token;
import org.netbeans.api.mdr.MDRepository;
import org.netbeans.mdr.handlers.AttrListWrapper;
import org.netbeans.mdr.handlers.BaseObjectHandler;
import org.netbeans.mdr.persistence.StorageException;
import org.netbeans.mdr.storagemodel.StorableObject;
import org.netbeans.modules.javacore.parser.ASTProvider;
import org.netbeans.modules.javacore.parser.ClassInfo;
import org.netbeans.modules.javacore.parser.ElementInfo;
import org.netbeans.modules.javacore.parser.MDRParser;
import org.netbeans.modules.javacore.parser.NameRef;
import org.openide.ErrorManager;
import javax.jmi.reflect.RefObject;
import java.util.*;
import org.openide.util.Utilities;

/**
 * @author Martin Matula
 */
public abstract class ClassDefinitionImpl extends SemiPersistentElement implements ClassDefinition {
    private ReferenceListWrapper interfaces;
    private JavaClass superClass;
    private LightAttrList contents;
    private final List featuresList;

    public ClassDefinitionImpl(StorableObject s) {
        super(s);
        this.featuresList = new FeaturesList(this);
    }

    protected abstract List super_getContents();

    public List getContents() {
        if (!childrenInited) {
            initChildren();
        }
        return contents;
    }

    public List getFeatures() {
        return featuresList;
    }

    public Collection getReferences() {
        return Collections.EMPTY_LIST;
    }
    
    public List getInterfaces() {
        if (interfaces == null) {
            interfaces = initInterfaces(interfaces, this);
        }
        return interfaces;
    }

    public JavaClass getSuperClass() {
        JavaClass result;

        // if the superclass has changed, the superClass variable is
        // initialized -> return its content
        if (isChanged(CHANGED_EXTENDS)) {
            if (superClass == null) {
                superClass = (JavaClass) ((JavaModelPackage) refImmediatePackage()).getType().resolve("java.lang.Object"); // NOI18N
            }
            result = superClass;
        } else {
            NameRef superClassName = ((ClassInfo) getElementInfo()).superclass;
            result = (JavaClass) resolveType(superClassName);
        }
        return result;
    }

    public void setSuperClass(JavaClass newValue) {
        throw new UnsupportedOperationException();
    }

    protected void initChildren() {
        initChildren(false);
    }

    protected void initChildren(boolean rebuild) {
        childrenInited = false;
        contents = createChildrenList(contents, "contents", ((ClassInfo) getElementInfo()).features, CHANGED_FEATURES, rebuild); // NOI18N
        childrenInited = true;
    }

    protected void matchPersistent(ElementInfo info) {
        if (childrenInited) {
            processMembers(getContents(), ((ClassInfo)info).features);
        }
    }

    protected void matchElementInfo(ElementInfo newInfo) {
        super.matchElementInfo(newInfo);
    }

    void setData(List features) {
        contents = createChildrenList("contents", features, CHANGED_FEATURES); // NOI18N
        childrenInited = true;
    }

    protected void _delete() {
        // --- delete components -------------------------------------------
        // delete all contents
        if (childrenInited) {
            deleteChildren(contents);
        }
        super._delete();
    }

    protected void resetChildren() {
        super.resetChildren();
        if (childrenInited) {
            initChildren(true);
        }
        if (interfaces != null) {
            interfaces = ClassDefinitionImpl.initInterfaces(interfaces, this);
        }
    }

    public List getChildren() {
        List l=new ArrayList(30);
        l.addAll(getContents());
        return l;
    }

    public String getSourceText() {
        String origElem;
        if ((origElem = checkChange()) != null)
            return origElem;
        StringBuffer buf = new StringBuffer();
        if (isNew()) 
            formatElementPart(CLASS_OPEN_CURLY, buf);
        generateNewFeatures(this, buf, false);
        if (isNew()) 
            formatElementPart(ANON_CLASS_CLOSE_CURLY, buf);
        return buf.toString();
    }

    public void getDiff(List diffList) {
        ClassInfo astInfo = (ClassInfo) getElementInfo();
        ASTProvider parser = getParser();

        // contents diff
        Token closeBrace = parser.getToken(getASTree().getLastToken());
        Token[] pad = closeBrace.getPadding();
        int endOffset = pad.length > 0 ? pad[0].getStartOffset() : closeBrace.getStartOffset();
        getCollectionDiff(diffList, parser, CHANGED_FEATURES, astInfo.features, getContents(), endOffset, "\n"); // NOI18N
    }

    public void replaceChild(Element oldElement, Element newElement) {
        if (childrenInited) {
            if (replaceObject(getContents(), oldElement, newElement)) return;
        }
    }

    protected ElementInfo getDefaultInfo() {
        return JavaClassImpl.DEFAULT_INFO;
    }

    // --------- Implementation of JMI operations -----------------------------------------------------------

    public Field getField(String name, boolean includeSupertypes) {
        return getField(this, name, includeSupertypes);
    }
    
    public Method getMethod(String name, List parameters, boolean includeSupertypes) {
        return getMethod(this, name, parameters, includeSupertypes);
    }
    
    public JavaClass getInnerClass(String simpleName, boolean includeSupertypes) {
        return getInnerClass(this, simpleName, includeSupertypes);
    }
    
    public Constructor getConstructor(List parameters, boolean includeSupertypes) {
        return getConstructor(this, parameters, includeSupertypes);
    }
        
    // static methods to which we delegate ......................................
    
    static Field getField (ClassDefinition cd, final String name, boolean includeSuperTypes) {
        MDRepository repository = ((BaseObjectHandler)cd).repository();
        repository.beginTrans(false);
        try {
            Field field = getField (cd, name);
            if ((field != null) || !includeSuperTypes) {
                return field;
            }
            return (Field) traverseSupertypes(cd, true, new Query() {
                public Object doQuery(ClassDefinition cd) {
                    return getField(cd, name);
                }
            });
        } finally {
            repository.endTrans(false);
        }
        
    }
    
    private static interface Query {
        Object doQuery(ClassDefinition cd);
    }
    
    private static Object traverseSupertypes(ClassDefinition cls, boolean includeInterfaces, Query query) {
        HashSet visited = new HashSet();
        LinkedList supers = includeInterfaces ? new LinkedList() : null;
        visited.add(cls);
        Object result;
        
        JavaClass jc = cls.getSuperClass();
        while (jc != null && visited.add(jc)) {
            result = query.doQuery(jc);
            if (result != null) {
                return result;
            }
            if (includeInterfaces) supers.addAll(jc.getInterfaces());
            jc = jc.getSuperClass();
        }
        
        if (includeInterfaces) {
            supers.addAll(0, cls.getInterfaces());

            // scan interfaces
            while (!supers.isEmpty()) {
                ClassDefinition cd = (ClassDefinition) supers.removeFirst();
                if (visited.add(cd)) {
                    result = query.doQuery(cd);
                    if (result != null) {
                        return result;
                    }
                    supers.addAll(cd.getInterfaces());
                }
            }
        }
        return null;
    }
    
    static JavaClass getInnerClass(ClassDefinition cd, final String name, boolean includeSuperTypes) {
        MDRepository repository = ((BaseObjectHandler)cd).repository();
        repository.beginTrans(false);
        try {
            JavaClass innerCls = getInnerClass(cd, name);
            if ((innerCls != null) || !includeSuperTypes) {
                return innerCls;
            }
            return (JavaClass) traverseSupertypes(cd, true, new Query() {
                public Object doQuery(ClassDefinition cd) {
                    return getInnerClass(cd, name);
                }
            });
        } finally {
            repository.endTrans(false);
        }
    }
    
    static Method getMethod (ClassDefinition cd, final String name, final List argTypes, boolean includeSuperTypes) {
        MDRepository repository = ((BaseObjectHandler)cd).repository();
        repository.beginTrans(false);
        try {
            Method method = getMethod (cd, name, argTypes);
            if ((method != null) || !includeSuperTypes) {
                return method;
            }
            return (Method) traverseSupertypes(cd, true, new Query() {
                public Object doQuery(ClassDefinition cd) {
                    return getMethod(cd, name, argTypes);
                }
            });
        } finally {
            repository.endTrans();
        }
    }
    
    static Constructor getConstructor(ClassDefinition cd, final List argTypes, boolean includeSuperTypes) {
        MDRepository repository = ((BaseObjectHandler)cd).repository();
        repository.beginTrans(false);
        try {
            Constructor constructor = getConstructor (cd, argTypes);
            if ((constructor != null) || !includeSuperTypes) {
                return constructor;
            }
            return (Constructor) traverseSupertypes(cd, false, new Query() {
                public Object doQuery(ClassDefinition cd) {
                    return getConstructor(cd, argTypes);
                }
            });
        } finally {
            repository.endTrans(false);
        }
    }
    
    // helper methods ...........................................................
    
    static Method getMethod (ClassDefinition cd, String name, List argTypes) {
        Iterator iter = cd.getContents().iterator();
        while (iter.hasNext()) {
            Object obj = iter.next ();
            if (obj instanceof Method) {
                Method method = (Method) obj;
                if (name.equals(method.getName()) && argTypesMatch(method, argTypes))
                    return method;
            }
        } // while
        return null;
    }
    
    static Constructor getConstructor (ClassDefinition cd, List argTypes) {
        Iterator iter = cd.getContents().iterator();
        while (iter.hasNext()) {
            Object obj = iter.next ();
            if (obj instanceof Constructor) {
                Constructor constr = (Constructor) obj;
                if (argTypesMatch(constr, argTypes))
                    return constr;
            }
        } // while
        return null;
    }
    
    static JavaClass getInnerClass (ClassDefinition cd, String name) {
        Iterator iter = cd.getContents().iterator();
        while (iter.hasNext()) {
            Object obj = iter.next ();
            if (obj instanceof JavaClass) {
                JavaClass jc = (JavaClass) obj;
                if (name.equals(jc.getSimpleName()))
                    return jc;
            }
        } // while
        return null;
    }
    
    static Field getField (ClassDefinition cd, String name) {
        Iterator iter = cd.getFeatures().iterator();
        while (iter.hasNext()) {
            Object obj = iter.next ();
            if (obj instanceof Field) {
                Field field = (Field) obj;
                if (name.equals(field.getName()))
                    return field;
            }
        } // while
        return null;
    }
    
    static boolean argTypesMatch (CallableFeature callable, List argTypes) {
        List pars = callable.getParameters ();
        if (argTypes.size () != pars.size ()) {
            return false;
        }
        Map typeParams = null;
        Iterator parsIter = pars.iterator ();
        Iterator argsIter = argTypes.iterator ();
        while (parsIter.hasNext ()) {
            Type t1 = TypeClassImpl.getRawType(((Parameter) parsIter.next ()).getType ());
            Type t2 = TypeClassImpl.getRawType((Type) argsIter.next ());
            if (!t1.getName().equals(t2.getName())) {
                return false;
            }
        } // while
        return true;
    }
    
    /** Initializes interfaces collection */
    static ReferenceListWrapper initInterfaces(ReferenceListWrapper interfaces, SemiPersistentElement javaClass) {
        NameRef[] interfaceNames = ((ClassInfo) javaClass.getElementInfo()).interfaces;
        // list of superinterfaces is transient
        TypeList _interfaces = new TypeList(javaClass);
        for (int i = 0; i<interfaceNames.length; i++) {
            _interfaces.addTypeRef(interfaceNames[i]);
        }
        if (interfaces == null) {
            ImplementsImpl implementsImpl = (ImplementsImpl)(((JavaModelPackage) javaClass.refImmediatePackage()).getImplements());
            interfaces = new ReferenceListWrapper(javaClass._getDelegate().getMdrStorage(), implementsImpl, javaClass, "interfaces", javaClass, CHANGED_IMPLEMENTS, _interfaces); // NOI18N
        } else {
            interfaces.setInnerList(_interfaces);
        }
        return interfaces;
    }

    static List getNakedFeatures(SemiPersistentElement javaClass) {
        try {
            return (List) ((StorableObject) javaClass._getDelegate()).getAttribute("contents"); // NOI18N
        } catch (StorageException e) {
            throw (GeneralException) ErrorManager.getDefault().annotate(new GeneralException(e.getMessage()), e);
        }
    }

    static List getPersistentContent(AttrListWrapper list) {
        list.setAttrName("contents"); // NOI18N
        return list;
    }

    /**
     * Prints all class contents to <tt>buf</tt>. 
     *
     * @param javaClass   print contents of this class
     * @param  buf        buffer to append contents to
     * @param  braces     print the curly braces
     */
    static void generateNewFeatures(ClassDefinition javaClass, StringBuffer buf, boolean braces) {
        MetadataElement cd = (MetadataElement) javaClass;
        if (!cd.isNew()) {
            // for the ClassDefinition, which has already tree, print the
            // whitespaces and comments as they were before
            ASTree tree = cd.getASTree();
            ASTree body;
            int treeType = tree.getType();
            if (treeType == ASTreeTypes.CLASS_BODY_DECLARATIONS) {
                body = tree;
            } else if (treeType == ASTreeTypes.ENUM_DECLARATION) {
                body = tree.getSubTrees()[3];
            } else if (treeType == ASTreeTypes.ANNOTATION_TYPE_DECLARATION) {
                body = tree.getSubTrees()[2];
            } else {
                body = tree.getSubTrees()[5];
            }
            buf.append(IndentUtil.reformatTokenWithPads(cd, body.getFirstToken()));
        } else {
            if (braces)
                ((MetadataElement) javaClass).formatElementPart(CLASS_OPEN_CURLY, buf);
        }
        List features = javaClass.getContents();
        if (javaClass instanceof JavaEnum) {
            JavaEnumImpl en = (JavaEnumImpl) javaClass;
            if (!en.getConstants().isEmpty())
                buf.append(getInnerIndentation(2));
            for (Iterator it = en.getConstants().iterator(); it.hasNext();) {
                MetadataElement constant = (MetadataElement) it.next();
                buf.append(constant.getSourceText());
                if (it.hasNext()) en.formatElementPart(COMMA, buf);
            }
            if (!en.getContents().isEmpty()) {
                // there isn't any feature, do not put semicolon at the end
                // of constant declaration.
                buf.append(";\n\n"); // NOI18N
            } else {
                if (!en.getConstants().isEmpty()) {
                    buf.append('\n');
                }
            }
        }
        if (!features.isEmpty()) {
            for (Iterator it = features.iterator(); it.hasNext(); ) {
                MetadataElement me = (MetadataElement) it.next();
                buf.append(me.getSourceText());
                if (me.isNew()) buf.append('\n');
            }
        }
        if (!cd.isNew()) {
            ASTree tree = cd.getASTree();
            buf.append(IndentUtil.reformatTokenWithPads(cd, tree.getLastToken()));
        } else {
            if (braces)
                ((MetadataElement) javaClass).formatElementPart(CLASS_CLOSE_CURLY, buf);
        }
    }

    protected String getIndentation() {
        MetadataElement parent = this;
        do {
            parent = (MetadataElement) parent.refImmediateComposite();
        } while (!(parent instanceof Statement || parent instanceof FieldGroup || (parent instanceof Field && parent.refImmediateComposite() instanceof ClassDefinition)));
        return parent.getIndentation();
    }
    
    static boolean isSubTypeOf(ClassDefinition thisClass, ClassDefinition clazz) {
        return isSubTypeOf(thisClass, clazz, new HashSet());
    }
    
    private static boolean isSubTypeOf(ClassDefinition thisClass, ClassDefinition clazz, Set visited) {
        if (thisClass == null || clazz == null) return false;
        
        // if this class was already checked, we know it is not a subtype -> return false immediately
        if (!visited.add(thisClass)) {
            return false;
        }
        
        clazz = getRealClassDefinition(clazz);

        // if the names of the classes match, we found the class traversing through supertypes -> it is a subtype
        if (Utilities.compareObjects(thisClass.getName(), clazz.getName())) {
            return true;
        }

        if ((thisClass instanceof JavaClass) && ((JavaClass) thisClass).isInterface()) {
            // if this class is an interface and class that it should be a subtype of is a class, we know the only case
            // where that could be true is if the supertype is java.lang.Object
            if (!((clazz instanceof JavaClass) && ((JavaClass) clazz).isInterface())) { 
                return "java.lang.Object".equals(clazz.getName()); // NOI18N
            }
        } else {
            // check superclasses only if this class is a class (not interface) - for interface it is handled in the condition above
            if (isSubTypeOf(getRealClassDefinition(thisClass.getSuperClass()), clazz, visited)) {
                return true;
            }
            // if clazz is not an interface, we must have found it by traversing through superclasses
            if (!((clazz instanceof JavaClass) && ((JavaClass) clazz).isInterface())) { 
                return false;
            }
        }

        // iterate through the super interfaces
        for (Iterator it = thisClass.getInterfaces().iterator(); it.hasNext();) {
            ClassDefinition ifc = getRealClassDefinition((ClassDefinition) it.next());
            if (isSubTypeOf(ifc, clazz, visited)) {
                return true;
            }
        }
        return false;
    }
    
    public static ClassDefinition getRealClassDefinition(ClassDefinition cls) {
        if (cls instanceof ParameterizedType) {
            return ((ParameterizedType) cls).getDefinition();
        }
        return cls;
    }
    
    public boolean isSubTypeOf(ClassDefinition clazz) {
        return isSubTypeOf(this, clazz);
    }

    protected void hardRefParent(boolean enabled) {
        // do not hardref parent - this object is transient
    }

    protected void parentChanged() {
        // do nothing on parentChanged - this object is transient
    }
    
    public Element duplicate(JavaModelPackage targetExtent) {
        return targetExtent.getClassDefinition().createClassDefinition(
                getName(),
                duplicateList(getContents(), targetExtent),
                (MultipartId) duplicateElement(getSuperClassName(), targetExtent),
                duplicateList(getInterfaceNames(), targetExtent)
               );
    }
}
