/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.modules.javacore.jmiimpl.javamodel;

import java.util.*;
import org.netbeans.jmi.javamodel.NamedElement;
import org.netbeans.lib.java.parser.ASTree;
import org.netbeans.modules.javacore.parser.ElementInfo;

/**
 *
 * @author  mm109185
 */
class CollectionMatcher {
    private Object[] oldArr;
    private Object[] newArr;
    private int[] map;
    
    /** Creates a new instance of CollectionMatcher */
    CollectionMatcher(Object[] oldElements, Object[] newElements) {
        oldArr=new Object[oldElements.length];
        System.arraycopy(oldElements,0,oldArr,0,oldElements.length);
        newArr=new Object[newElements.length];        
        for(int i=0;i<newElements.length;i++) {
            MetadataElement el=(MetadataElement)newElements[i];
            newArr[i]=oldElements instanceof String[] ? ((NamedElement) el).getName() : el.getInternalForm();
        }
    }
    
    /** @returns indexes to oldElements array. oldIndex=getPositions()[newIndex]
     * -1 - element was deleted
     */ 
    int[] getPositions() {
        if (map==null)
            mapArray();
        return map;
    }
    
    /** @returns Set of deleted objects 
     */
    Set getDeleted() {
        int i;
        Set deleted=new HashSet();

        if (map==null)
            mapArray();
        for (i=0;i<oldArr.length;i++) {
            Object obj=oldArr[i];

            if (obj!=null)
                deleted.add(obj);
        }
        return deleted;
    }

    private final void mapArray() {
        int i;
        Map oldMap=new HashMap();
        
        for (i=0;i<oldArr.length;i++) {
            oldMap.put(oldArr[i],new Integer(i));
        }
        map=new int[newArr.length];
        Arrays.fill(map,-1);
        for (i=0;i<newArr.length;i++) {
            Object newObj=newArr[i];
            Integer oldIndex=(Integer)oldMap.get(newObj);
                
            if (oldIndex!=null) {
                int index=oldIndex.intValue();

                map[i]=index;
                oldArr[index]=null;
            }
        }
    }
}
