/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.modules.javacore.jmiimpl.javamodel;

import java.util.*;
import org.netbeans.jmi.javamodel.ComplexExpression;
import org.netbeans.jmi.javamodel.Element;
import org.netbeans.jmi.javamodel.Expression;
import org.netbeans.jmi.javamodel.JavaModelPackage;
import org.netbeans.lib.java.parser.ASTree;
import org.netbeans.mdr.storagemodel.StorableObject;
import org.netbeans.modules.javacore.parser.ASTProvider;

/**
 *
 * @author  Martin Matula
 */
public abstract class ComplexExpressionImpl extends ExpressionImpl implements ComplexExpression {
    private Expression expression = null;
    
    /** Creates a new instance of ComplexExpressionImpl */
    public ComplexExpressionImpl(StorableObject o) {
        super(o);
    }
    
    public void setExpression(Expression expression) {
        objectChanged(CHANGED_EXPRESSION);
        changeChild(getExpression(), expression);
        this.expression = expression;
    }
    
    public Expression getExpression() {
        if (!childrenInited) {
            initChildren();
        }
        return expression;
    }
    
    public List getChildren() {
        List list = new ArrayList(1);
        addIfNotNull(list, getExpression()); 
        return list;
    }

    protected void initChildren() {
        childrenInited = false;
        ASTree tree = getASTree();
        if (tree != null) {
            expression = (Expression) initOrCreate(expression, tree.getSubTrees()[0]);
        }
        childrenInited = true;
    }
    
    String getRawText() {
        StringBuffer buf = new StringBuffer();
        StatementImpl expr = (StatementImpl) getExpression();
        formatElementPart(STMT_OPEN_BRACKET, buf);
        buf.append(expr.getSourceText());
        formatElementPart(STMT_CLOSE_BRACKET, buf);
        return buf.toString();
    }
    
    public void getDiff(List diff) {
        ASTProvider parser = getParser();
        ASTree tree = getASTree();
        ASTree[] children = tree.getSubTrees();

        getChildDiff(diff, parser, children[0], (MetadataElement) getExpression(), CHANGED_EXPRESSION);
    }
    
    void setData(Expression expression) {
        changeChild(null, expression);
        this.expression = expression;
    }

    protected void _delete() {
        // --- delete components -------------------------------------------
        if (childrenInited) {
            deleteChild(expression);
        }
        // --- delete links -----------------------------------------------
        // no links to delete
        // --- call super ---------------------------------------
        super._delete();
    }
    
    public void replaceChild(Element oldElement,Element newElement) {
        if (childrenInited) {
            if (oldElement.equals(expression)) {
                setExpression((Expression)newElement);
            }
        }
    }
    
    public Element duplicate(JavaModelPackage targetExtent) {
        return targetExtent.getComplexExpression().createComplexExpression(
                (Expression) duplicateElement(getExpression(), targetExtent));
    }
}
