/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.modules.javacore.jmiimpl.javamodel;

import java.util.*;
import org.netbeans.jmi.javamodel.ConditionalExpression;
import org.netbeans.jmi.javamodel.Element;
import org.netbeans.jmi.javamodel.Expression;
import org.netbeans.jmi.javamodel.JavaModelPackage;
import org.netbeans.lib.java.parser.ASTree;
import org.netbeans.mdr.storagemodel.StorableObject;
import org.netbeans.modules.javacore.parser.ASTProvider;

/**
 *
 * @author  Martin Matula
 */
public abstract class ConditionalExpressionImpl extends ExpressionImpl implements ConditionalExpression {
    private Expression condition = null;
    private Expression truePart = null;
    private Expression falsePart = null;
    
    /** Creates a new instance of ConditionalExpressionImpl */
    public ConditionalExpressionImpl(StorableObject o) {
        super(o);
    }
    
    public void setCondition(Expression condition) {
        objectChanged(CHANGED_CONDITION);
        changeChild(getCondition(), condition);
        this.condition = condition;
    }
    
    public Expression getCondition() {
        if (!childrenInited) {
            initChildren();
        }
        return condition;
    }
    
    public void setTruePart(Expression truePart) {
        objectChanged(CHANGED_TRUE_PART);
        changeChild(getTruePart(), truePart);
        this.truePart = truePart;
    }
    
    public Expression getTruePart() {
        if (!childrenInited) {
            initChildren();
        }
        return truePart;
    }
    
    public void setFalsePart(Expression falsePart) {
        objectChanged(CHANGED_FALSE_PART);
        changeChild(getFalsePart(), falsePart);
        this.falsePart = falsePart;
    }
    
    public Expression getFalsePart() {
        if (!childrenInited) {
            initChildren();
        }
        return falsePart;
    }
    
    public List getChildren() {
        List list = new ArrayList(3);
        addIfNotNull(list, getCondition()); 
        addIfNotNull(list, getTruePart()); 
        addIfNotNull(list, getFalsePart()); 
        return list;
    }
    
    protected void initChildren() {
        childrenInited = false;
        ASTree tree = getASTree();
        if (tree != null) {
            ASTree[] parts = tree.getSubTrees();
            condition = (Expression) initOrCreate(condition, parts[0]);
            truePart = (Expression) initOrCreate(truePart, parts[1]);
            falsePart = (Expression) initOrCreate(falsePart, parts[2]);
        }
        childrenInited = true;
    }
    
    public String getSourceText() {
        String origElem;
        if ((origElem = checkChange()) != null)
            return origElem;
        StringBuffer buf = new StringBuffer();
        StatementImpl cond = (StatementImpl) getCondition();
        StatementImpl falsePart = (StatementImpl) getFalsePart();
        StatementImpl truePart = (StatementImpl) getTruePart();
        buf.append(cond.getSourceText());
        formatElementPart(COND_EXPR_QUESTION, buf);
        buf.append(truePart.getSourceText());
        formatElementPart(COND_EXPR_COLON, buf);
        buf.append(falsePart.getSourceText());
        return buf.toString();
    }
        
    public void getDiff(List diff) {
        ASTProvider parser = getParser();
        ASTree tree = getASTree();
        ASTree[] children = tree.getSubTrees();

        getChildDiff(diff, parser, children[0], (MetadataElement) getCondition(), CHANGED_CONDITION);
        getChildDiff(diff, parser, children[1], (MetadataElement) getTruePart(), CHANGED_TRUE_PART);
        getChildDiff(diff, parser, children[2], (MetadataElement) getFalsePart(), CHANGED_FALSE_PART);
    }
    
    void setData(Expression condition, Expression truePart, Expression falsePart) {
        changeChild(null, condition);
        this.condition = condition;
        changeChild(null, truePart);
        this.truePart = truePart;
        changeChild(null, falsePart);
        this.falsePart = falsePart;
    }

    protected void _delete() {
        // --- delete components -------------------------------------------
        if (childrenInited) {
            deleteChild(condition);
            deleteChild(truePart);
            deleteChild(falsePart);
        }
        // --- delete links -----------------------------------------------
        // no links to delete
        // --- call super ---------------------------------------
        super._delete();
    }
    
    public void replaceChild(Element oldElement,Element newElement) {
        if (childrenInited) {
            if (oldElement.equals(condition)) {
                setCondition((Expression)newElement);
            } else if (oldElement.equals(truePart)) {
                setTruePart((Expression)newElement);
            } else if (oldElement.equals(falsePart)) {
                setFalsePart((Expression)newElement);
            }
        }
    }
    
    public Element duplicate(JavaModelPackage targetExtent) {
        return targetExtent.getConditionalExpression().createConditionalExpression(
                (Expression) duplicateElement(getCondition(), targetExtent),
                (Expression) duplicateElement(getTruePart(), targetExtent),
                (Expression) duplicateElement(getFalsePart(), targetExtent)
               );
    }
}
