/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.modules.javacore.jmiimpl.javamodel;

import java.util.Arrays;
import java.util.List;

import org.netbeans.jmi.javamodel.Constructor;
import org.netbeans.jmi.javamodel.ConstructorClass;
import org.netbeans.jmi.javamodel.JavaDoc;
import org.netbeans.jmi.javamodel.StatementBlock;
import org.netbeans.mdr.storagemodel.StorableClass;
import org.netbeans.modules.javacore.parser.TypeParamRef;


/**
 * Implementation of Constructor class proxy interface.
 *
 * @author Martin Matula, Vladimir Hudec
 */
public abstract class ConstructorClassImpl extends SemiPersistentClass implements ConstructorClass {
    protected ConstructorClassImpl(StorableClass s) {
        super(s);
    }
    
    /**
     * The default factory operation used to create an instance object.
     * @return The created instance object.
     */
    public Constructor createConstructor() {
        return create(null, 0, null, null, null, null, null, null, null);
    }
    
    public Constructor createConstructor(java.lang.String name, List annotations, int modifiers, java.lang.String javadocText, JavaDoc javadoc, StatementBlock body, java.lang.String bodyText, List typeArguments, List parameters, List exceptionNames) {
        return create(annotations, modifiers, javadocText, javadoc, body, bodyText, typeArguments, parameters, exceptionNames);
    }

    private Constructor create(List annotations, int modifiers, java.lang.String javadocText, JavaDoc javadoc, StatementBlock body, java.lang.String bodyText, List typeArguments, List parameters, List exceptionNames) {
        ConstructorImpl result = create(modifiers, null, false);
        result.setNew();
        result.setData(annotations, javadocText, javadoc, body, bodyText, typeArguments, parameters, exceptionNames);
        return result;
    }

    public ConstructorImpl create(int modifiers, TypeParamRef[] exceptions, boolean isTransient) {
        ConstructorImpl result;
        if (isTransient) {
            result = (ConstructorImpl) createTransient();
            boolean changes = result.disableChanges;
            result.disableChanges = true;
            try {
                result.setModifiers(modifiers);
            } finally {
                result.disableChanges = changes;
            }
        } else {
            result = (ConstructorImpl) super_createConstructor(null, null, modifiers, null, null, null, null, null, null, null);
        }
        result.setExceptionRefs(exceptions == null ? null : Arrays.asList(exceptions));
        return result;
    }

    protected abstract Constructor super_createConstructor();
    protected abstract Constructor super_createConstructor(java.lang.String name, List annotations, int modifiers, java.lang.String javadocText, JavaDoc javadoc, StatementBlock body, java.lang.String bodyText, List typeArguments, List parameters, List exceptionNames);
}
