/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.modules.javacore.jmiimpl.javamodel;
import org.netbeans.jmi.javamodel.*;
import org.netbeans.mdr.storagemodel.StorableObject;
import org.netbeans.modules.javacore.parser.ElementInfo;
import org.netbeans.modules.javacore.parser.MethodInfo;
import javax.jmi.model.MofClass;
import javax.jmi.model.NameNotFoundException;
import javax.jmi.reflect.ConstraintViolationException;
import javax.jmi.reflect.RefObject;
import java.util.List;
import org.netbeans.lib.java.parser.ASTree;
import org.netbeans.modules.javacore.parser.ASTProvider;

/**
 *
 * @author  Martin Matula
 */
public abstract class ConstructorImpl extends CallableFeatureImpl implements Constructor {
    private static final ElementInfo DEFAULT_INFO = new MethodInfo(null, MethodInfo.CONSTRUCTOR_TYPE, null, 0, null, null, null, null, null);

    /** Creates a new instance of MethodImpl */
    public ConstructorImpl(StorableObject s) {
        super(s);
    }

    protected ElementInfo getDefaultInfo() {
        return DEFAULT_INFO;
    }

    protected void matchName(ElementInfo info) {
        // do not match name
    }

    public List getChildren() {
        List list = super.getChildren();
        list.addAll(0, getAnnotations());
        return list;
    }

    public String getName() {
        return null;
    }

    public void setName(String name) {
        // cannot set name of the constructor
        throw new UnsupportedOperationException("Cannot set name of a constructor."); // NOI18N
    }

    /**
     * Returns the value of reference type.
     * @return Value of reference type.
     */
    public org.netbeans.jmi.javamodel.Type getType() {
        return (JavaClass) getDeclaringClass();
    }

    /**
     * Sets the value of reference type. See {@link #getType} for description
     * on the reference.
     * @param newValue New value to be set.
     */
    public void setType(org.netbeans.jmi.javamodel.Type newValue) {
        RefObject nameAttr = null;
        try {
            nameAttr = ((MofClass) refMetaObject()).lookupElementExtended("type"); // NOI18N
        } catch (NameNotFoundException e) {
            // ignore
        }
        throw new ConstraintViolationException(this, nameAttr, "Type is readonly."); // NOI18N
    }

    // .........................................................................
    // printing and formatting fuctionality
    // .........................................................................

    /**
     * Implementation of abstract method defined in CallableFeatureImpl.
     * Appends to buffer parents name.
     *
     * @param  buf  buffer to append to
     */
    void generateTypeAndName(StringBuffer buf) {
        ClassDefinition def = getDeclaringClass();
        if (def instanceof JavaClass)
            buf.append(((JavaClass) def).getSimpleName());
        else
            throw new UnsupportedOperationException("It is denied to add " + // NOI18N
                "constructor to\nthe anonymous class!"); // NOI18N
        formatElementPart(CALLABLE_IDENTIFIER, buf);
    }

    String getRawText() {
        if (!elementsInited) {
            initASTElements();
        }
        StringBuffer buf = new StringBuffer();
        generateHeader(buf);
        generateBody(buf);
        return buf.toString();
    }

    public void getDiff(List diffList) {
        MethodInfo astInfo = (MethodInfo) getElementInfo();
        ASTProvider parser = getParser();
        ASTree tree = getASTree();
        ASTree[] children = tree.getSubTrees();

        // javadoc print
        replaceJavaDoc(diffList);
        // modifier print
        ASTree type = children[2];
        if (isChanged(CHANGED_MODIFIERS) || isChanged(CHANGED_ANNOTATION)) {
            diffModifiers(diffList, type == null ? children[3] : type, parser);
        } else if (children[0] != null) {
            getCollectionDiff(diffList, parser, CHANGED_ANNOTATION, astInfo.annotations, getAnnotations(), parser.getToken(children[0].getLastToken()).getEndOffset(), " "); // NOI18N
        }
        getTypeParamsDiff(diffList);
        // name
        ASTree declarator = tree.getSubTrees()[3];
        if (isChanged(CHANGED_NAME)) {
            String newName = ((JavaClass) getDeclaringClass()).getSimpleName();
            replaceNode(diffList, parser, declarator.getSubTrees()[0], newName, 0, null);
        }
        // parameters
        String comma = formatElementPart(COMMA);
        int endOffset = parser.getToken(declarator.getLastToken()).getStartOffset();
        getCollectionDiff(diffList, parser, CHANGED_PARAMETERS,
            astInfo.parameters, getParameters(), endOffset, comma);
        // exceptions
        int startOffset = parser.getToken(declarator.getLastToken()).getEndOffset();
        getCollectionDiff(diffList, parser, CHANGED_THROWS, tree.getSubTrees()[4],
                getExceptionNames(), startOffset, comma, formatElementPart(THROWS_KEYWORD));
        // body print
        createBodyDiffs(diffList);
    }
    
    public Element duplicate(JavaModelPackage targetExtent) {
        StatementBlock body;
        String bodyText;
        
        if (isChanged(CHANGED_BODY) && this.bodyText != null) {
            body = null;
            bodyText = this.bodyText;
        } else {
            body = (StatementBlock) duplicateElement(getBody(), targetExtent);
            bodyText = null;
        }
        
        return targetExtent.getConstructor().createConstructor(
                null,
                duplicateList(getAnnotations(), targetExtent),
                getModifiers(),
                null,
                (JavaDoc) duplicateElement(getJavadoc(), targetExtent),
                body,
                bodyText,
                duplicateList(getTypeParameters(), targetExtent),
                duplicateList(getParameters(), targetExtent),
                duplicateList(getExceptionNames(), targetExtent)
            );
    }
}
