/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.modules.javacore.jmiimpl.javamodel;

import javax.jmi.reflect.RefObject;
import org.netbeans.mdr.handlers.FeaturedHandler;
import org.netbeans.mdr.persistence.MOFID;
import org.netbeans.mdr.persistence.StorageException;
import org.netbeans.mdr.storagemodel.*;

public class DeferredObject extends StorableObject implements Transient {
    
    private static long mofIdCounter = 0; // variable used to generate mof id's
    private static final String DEFERRED_STORAGE_ID = "deferredStorage"; // NOI18N
    
    private final MdrStorage mdrStorage;
    private final StorableObject metaObject;
    private final StorableClass classProxy;
    private StorableFeatured immediateComposite;
    private FeaturedHandler icHandler;
    private final MOFID mofId;
    private final MOFID outermostPackageId;
            
    // ..........................................................................
    
    public static synchronized MOFID generateNextMofid() {
        return new MOFID (mofIdCounter++, DEFERRED_STORAGE_ID);
    }
    
    // ..........................................................................
    
    public DeferredObject(MOFID mofId, MdrStorage mdrStorage, MOFID immediatePackageId, MOFID outermostPackageId, 
      StorableObject metaObject, StorableClass classProxy, StorableFeatured immediateComposite) throws StorageException {
          this(mofId, mdrStorage, immediatePackageId, outermostPackageId, metaObject, classProxy, immediateComposite, false);
    }
    /** Creates a new instance of DeferredObject */
    public DeferredObject(MOFID mofId, MdrStorage mdrStorage, MOFID immediatePackageId, MOFID outermostPackageId, 
      StorableObject metaObject, StorableClass classProxy, StorableFeatured immediateComposite, boolean initializeValues) throws StorageException {
        super();
        this.mdrStorage = mdrStorage;
        this.immediatePackage = immediatePackageId;
        this.outermostPackageId = outermostPackageId;
        this.metaObject = metaObject;
        this.classProxy = classProxy;
        this.immediateComposite = immediateComposite;
        // immediate composite must be hard-referenced
        icHandler = (FeaturedHandler) mdrStorage.getRepository().getHandler(immediateComposite);
        if (mofId == null) {
            this.mofId = generateNextMofid();        
        } else {
            this.mofId = mofId;
        }

        if (initializeValues) {
            check();
            int count = values.length;
            for (int i = 0; i < count; i++) {
                StorableClass.AttributeDescriptor desc = classProxy.getAttrDesc(i);
                values[i] = getInitialValue(desc, null);
            }
        }

        mdrStorage.registerExternal(this);
    }

    public DeferredObject(StorableObject storable) throws StorageException {
        this(storable.getMofId(), storable.getMdrStorage(), storable.getImmediatePackageId(), storable.getOutermostPackageId(),
                storable.getMetaObject(), storable.getClassProxy(), storable.getImmediateComposite());
        copyValues(storable);
    }

    public MOFID getMofId() {
        return mofId;
    }
    
    public StorableFeatured getImmediateComposite() throws StorageException {
        return immediateComposite;
    }
    
    public void setComposite(StorableBaseObject composite, org.netbeans.mdr.persistence.MOFID objectId, org.netbeans.mdr.persistence.MOFID elementId) throws StorageException {
        if (composite == null) {
            immediateComposite = null;
            icHandler = null;
        } else {
            org.netbeans.mdr.persistence.MOFID id = composite.getMofId();
            if (immediateComposite == null || !id.equals(immediateComposite.getMofId())) {
                // check for Composition Violation
                if (immediateComposite != null) {
                    throw new javax.jmi.reflect.CompositionViolationException(getMdrStorage().getRepository().getHandler(this), (RefObject) getMdrStorage().getRepository().getHandler(getMdrStorage().getObject(elementId)));
                }
                // check for Composition Cycle
                if ((composite instanceof StorableObject) && (((StorableObject) composite).getOutermostComposite().equals(this))) {
                    throw new javax.jmi.reflect.CompositionCycleException(getMdrStorage().getRepository().getHandler(getMdrStorage().getObject(objectId)), (RefObject) getMdrStorage().getRepository().getHandler(getMdrStorage().getObject(elementId)));
                }
                // check for Composition Closure
                if (!composite.getOutermostPackageId().equals(getOutermostPackageId())) {
                    throw new javax.jmi.reflect.ClosureViolationException(getMdrStorage().getRepository().getHandler(getMdrStorage().getObject(objectId)), (RefObject) getMdrStorage().getRepository().getHandler(getMdrStorage().getObject(elementId)));
                }
                immediateComposite = (StorableFeatured) composite;
                icHandler = (FeaturedHandler) mdrStorage.getRepository().getHandler(immediateComposite);
            }
        }
        objectChanged ();
    }

    public void deleteInstance() throws StorageException {
        // do nothing
    }

    public StorableObject getMetaObject() {
        return metaObject;
    }
    
    public MOFID getClassProxyId() {
        return classProxy.getMofId();
    }
    
    public StorableClass getClassProxy() {
        return classProxy;
    }
    
    public MOFID getOutermostPackageId() {        
        return outermostPackageId;
    }
    
    public MdrStorage getMdrStorage () {
        return mdrStorage;
    }
    
    public void objectWillChange() {
        // do nothing
    }
    
    public void objectChanged() {
        // do nothing
    }
    
    /** Returns string representation of this object.
     * @return string representation of this object
     */    
    public String toString () {
        return getClass().getName() + "(" + mofId.toString() + ")"; // NOI18N
    }

    /** Returns object's hashcode
     * @return hashcode
     */
    public int hashCode() {
        return mofId.hashCode();
    }
    
    protected void deleteRecursive() {
        mdrStorage.removeExternal(this);
    }
    
}
