/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.modules.javacore.jmiimpl.javamodel;

import java.util.List;
import org.netbeans.jmi.javamodel.DoStatement;
import org.netbeans.jmi.javamodel.Element;
import org.netbeans.jmi.javamodel.Expression;
import org.netbeans.jmi.javamodel.JavaModelPackage;
import org.netbeans.jmi.javamodel.Statement;
import org.netbeans.lib.java.parser.ASTree;
import org.netbeans.mdr.storagemodel.StorableObject;
import org.netbeans.modules.javacore.parser.ASTProvider;

/**
 *
 * @author  Martin Matula
 */
public abstract class DoStatementImpl extends WhileStatementImpl implements DoStatement {
    
    /** Creates a new instance of DoStatementImpl */
    public DoStatementImpl(StorableObject o) {
        super(o);
    }
    
    protected void initChildren() {
        childrenInited = false;
        ASTree tree = getASTree();
        if (tree != null) {
            ASTree[] parts = tree.getSubTrees();
            body = (Statement) initOrCreate(body, parts[0]);
            expression = (Expression) initOrCreate(expression, parts[1]);
        }
        childrenInited = true;
    }
    
    public String getSourceText() {
        String origElem;
        if ((origElem = checkChange()) != null)
            return origElem;
        StringBuffer buf = new StringBuffer();
        StatementImpl cond = (StatementImpl) getExpression();
        StatementImpl body = (StatementImpl) getBody();
        buf.append('\n');
        formatElementPart(DO_KEYWORD, buf);
        buf.append(body.getSourceText());
        buf.append(DO_WHILE_KEYWORD);
        formatElementPart(STMT_OPEN_BRACKET, buf);
        buf.append(cond.getSourceText());
        formatElementPart(STMT_CLOSE_BRACKET, buf);
        return buf.toString();
    }

    public void getDiff(List diff) {
        ASTProvider parser = getParser();
        ASTree tree = getASTree();
        ASTree[] children = tree.getSubTrees();
        
        getChildDiff(diff, parser, children[0], (MetadataElement) getBody(), CHANGED_BODY);
        getChildDiff(diff, parser, children[1], (MetadataElement) getExpression(), CHANGED_EXPRESSION);
    }
    
    public Element duplicate(JavaModelPackage targetExtent) {
        return targetExtent.getDoStatement().createDoStatement(
                (Expression) duplicateElement(getExpression(), targetExtent),
                (Statement) duplicateElement(getBody(), targetExtent)
               );
    }
}
