/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.javacore.jmiimpl.javamodel;

import org.netbeans.jmi.javamodel.*;
import org.netbeans.lib.java.parser.ASTree;
import org.netbeans.lib.java.parser.ParserTokens;
import org.netbeans.lib.java.parser.Token;
import org.netbeans.modules.javacore.parser.ASTProvider;
import java.util.Arrays;

/**
 *
 * @author  Tomas Hurka
 */
class ElementNavigator {
    private int idIndexes[];
    
    ElementNavigator(Resource r,NamedElement element) {
        ResourceImpl impl=(ResourceImpl)r;
        ASTProvider parser=impl.getParser();
        ASTree tree;
        
        if (element instanceof Parameter)
            tree = ((MetadataElement)element.refImmediateComposite()).getASTree();
        else
            tree = impl.getASTree();
        if (parser!=null) {
            int lastToken=tree.getLastToken();
            int ids[]=new int[lastToken];
            int i,idIndex=0;
            String id;
            String fullPackageName=null;

            if (element instanceof JavaClass) {
                id=((JavaClass)element).getSimpleName();
            } else if (element instanceof JavaPackage) {
                fullPackageName=id=element.getName();
                int lastDot=id.lastIndexOf('.');

                if (lastDot!=-1)
                    id=id.substring(lastDot+1);
            } else if (element instanceof Constructor) {
                id=((JavaClass)((Constructor)element).getDeclaringClass()).getSimpleName();
            } else 
                id=element.getName();

            for (i=tree.getFirstToken();i<=lastToken;i++) {
                Token token=parser.getToken(i);
                int type=token.getType();
                
                if ((type==ParserTokens.THIS || type==ParserTokens.SUPER) && element instanceof Constructor) {
                    Token nextToken=parser.getToken(i+1);
                    if (nextToken.getType()==ParserTokens.L_PAR) {
                        ids[idIndex++]=i;   
                    }
                } else if (type==ParserTokens.IDENTIFIER && id.equals(token.getValue())) {
                    try {
                        if (element instanceof Field || element instanceof CallableFeature) {
                            Token nextToken=parser.getToken(i+1);

                            if (nextToken.getType()==ParserTokens.L_PAR) {
                                if (element instanceof Field)
                                    continue;
                                if (element instanceof Constructor) {
                                    int offset=1;
                                    Token prevToken;
                                    while(true) {
                                        prevToken=parser.getToken(i-offset);
                                        if (prevToken.getType()!=ParserTokens.DOT)
                                            break;
                                        offset++;
                                        prevToken=parser.getToken(i-offset);
                                        if (prevToken.getType()!=ParserTokens.IDENTIFIER)
                                            break;
                                        offset++;
                                    }
                                    if (prevToken.getType()!=ParserTokens.NEW)
                                        continue;
                                }
                            } else {
                                if (element instanceof CallableFeature)
                                    continue;
                            }
                        } else if (element instanceof JavaPackage) {
                            int offset=1;
                            StringBuffer packageName=new StringBuffer(id);

                            while(true) {
                                Token prevToken=parser.getToken(i-offset);
                                if (prevToken.getType()!=ParserTokens.DOT)
                                    break;
                                offset++;
                                packageName.insert(0,'.');
                                prevToken=parser.getToken(i-offset);
                                if (prevToken.getType()!=ParserTokens.IDENTIFIER)
                                    break;
                                offset++;
                                packageName.insert(0,prevToken.getValue());
                            }
                            if (!packageName.toString().equals(fullPackageName))
                                continue;
                        }
                    } catch (IndexOutOfBoundsException ex) {
                        // we are out of token bounds
                        continue;
                    }
                    ids[idIndex++]=i;
                }
            }
            idIndexes=new int[idIndex];
            System.arraycopy(ids, 0, idIndexes, 0, idIndex);
        } else {
            throw new IllegalArgumentException("ASTProvider is null"); // NOI18N
        }
    }
    
    
    boolean containsIdentifierIn(MetadataElement element) {
        int first,last,index;
        ASTree tree=element.getASTree();
        
        if (tree==null)
            throw new IllegalArgumentException("Illegal element "+element); // NOI18N
        first=tree.getFirstToken();
        last=tree.getLastToken();
        index=Arrays.binarySearch(idIndexes,first);
        if (index>=0)
            return true;
        index=-index-1;
        if (index==idIndexes.length)
            return false;
        return idIndexes[index]<=last;
    }    
}
