/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.modules.javacore.jmiimpl.javamodel;

import java.util.ArrayList;
import java.util.Collection;
import org.netbeans.jmi.javamodel.*;
import org.netbeans.lib.java.parser.ASTree;
import org.netbeans.mdr.storagemodel.StorableObject;
import org.netbeans.modules.javacore.parser.ASTUtil;

/**
 *
 * @author Martin Matula
 */
public abstract class ElementReferenceImpl extends ExpressionImpl {
    protected String name = null;
    
    /** Creates a new instance of ElementReferenceImpl */
    public ElementReferenceImpl(StorableObject o) {
        super(o);
    }
    
    public String getName() {
        if (isChanged(CHANGED_NAME)) {
            return name;
        } else {
            return getParser().getText(getNameAST());
        }
    }
    
    public void setName(String name) {
        objectChanged(CHANGED_NAME);
        this.name = name;
    }
    
    protected ASTree getNameAST() {
        return getASTree().getSubTrees()[2];
    }

    protected ASTree getPartTree(ElementPartKind part) {
        if (ElementPartKindEnum.NAME.equals(part)) {
            return getNameAST();
        }
        throw new IllegalArgumentException("Invalid part for this element: " + part); // NOI18N
    }
    
    void setData(String name) {
        this.name = name;
    }
    
    public NamedElement getElement() {
        return (NamedElement) getParser().getSemanticInfo(getASTree(), this);
    }
}
