/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.modules.javacore.jmiimpl.javamodel;

import org.netbeans.jmi.javamodel.Field;
import org.netbeans.jmi.javamodel.FieldClass;
import org.netbeans.jmi.javamodel.TypeReference;
import org.netbeans.mdr.storagemodel.StorableClass;
import org.netbeans.modules.javacore.parser.TypeRef;

/**
 * Implementation of Field class proxy interface.
 *
 * @author Vladimir Hudec
 */
public abstract class FieldClassImpl extends SemiPersistentClass implements FieldClass {
    
    protected FieldClassImpl(StorableClass s) {
        super(s);
    }
    
    /**
     * The default factory operation used to create an instance object.
     * @return The created instance object.
     */
    public Field createField() {
        return create(null, null, false, null, 0, null, null, 0, null, null);
    }
    
    /**
     * Creates an instance object having attributes initialized by the passed 
     * values.
     * @param name 
     * @param annotations 
     * @param isFinal 
     * @param initialValue 
     * @param initialValueText 
     * @param modifiers 
     * @param javadocText 
     * @param javadoc 
     * @return The created instance object.
     */
    public Field createField(java.lang.String name, java.util.List annotations, int modifiers, java.lang.String javadocText, org.netbeans.jmi.javamodel.JavaDoc javadoc, boolean isFinal, org.netbeans.jmi.javamodel.TypeReference typeName, int dimCount, org.netbeans.jmi.javamodel.InitialValue initialValue, java.lang.String initialValueText) {
        return create(name, annotations, isFinal, typeName, dimCount, initialValue, initialValueText, modifiers, javadocText, javadoc);
    }
    
    private Field create(java.lang.String name, java.util.List annotations, boolean isFinal, TypeReference typeName, int dimCount, org.netbeans.jmi.javamodel.InitialValue initialValue, java.lang.String initialValueText, int modifiers, java.lang.String javadocText, org.netbeans.jmi.javamodel.JavaDoc javadoc) {
        FieldImpl result = create(name, modifiers, null, false);
        result.setNew();
        result.setData(annotations, modifiers, javadocText, javadoc, isFinal, typeName, dimCount, initialValue, initialValueText);
        return result;
    }

    public FieldImpl create(String name, int modifiers, TypeRef type, boolean isTransient) {
        FieldImpl result;
        if (isTransient) {
            result = (FieldImpl) createTransient();
            boolean changes = result.disableChanges;
            result.disableChanges = true;
            try {
                result.setName(name);
                result.setModifiers(modifiers);
            } finally {
                result.disableChanges = changes;
            }
        } else {
            result = (FieldImpl) super_createField(name, null, modifiers, null, null, false, null, 0, null, null);
        }
        result.setTypeRef(type);
        return result;
    }

    protected abstract Field super_createField();
    protected abstract Field super_createField(java.lang.String name, java.util.List annotations, int modifiers, java.lang.String javadocText, org.netbeans.jmi.javamodel.JavaDoc javadoc, boolean isFinal, org.netbeans.jmi.javamodel.TypeReference typeName, int dimCount, org.netbeans.jmi.javamodel.InitialValue initialValue, java.lang.String initialValueText);
}
