/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.modules.javacore.jmiimpl.javamodel;

import java.lang.reflect.Modifier;
import org.netbeans.jmi.javamodel.*;
import org.netbeans.lib.java.parser.ASTree;
import org.netbeans.mdr.handlers.AttrListWrapper;
import org.netbeans.mdr.persistence.StorageException;
import org.netbeans.mdr.storagemodel.StorableObject;
import org.netbeans.modules.javacore.parser.*;
import org.openide.util.Utilities;
import org.openide.ErrorManager;
import java.util.*;


/**
 *
 * @author  Pavel Flaska
 * @author  Martin Matula
 */
public abstract class FieldGroupImpl extends FeatureImpl implements FieldGroup {
    public static final String FIELDS_ATTR = "fields"; // NOI18N
    private static final ElementInfo DEFAULT_INFO = new FieldGroupInfo(null, FieldGroupInfo.FIELDGROUP_TYPE, 0, null, null, null);

    private TypeReference typeName;
    private LightAttrList fields;

    private boolean elementsInited = false;

    /** Creates a new instance of FieldGroupImpl */
    protected FieldGroupImpl(StorableObject s) {
        super(s);
    }

    public void setType(Type newValue) {
        TypeRef tr = typeToTypeRef(newValue);
        _setTypeName((TypeReference) typeRefToTypeReference(tr, 0), tr);
    }

    public Type getType() {
        checkUpToDate();
        return resolveType(getTypeRef());
    }

    public TypeReference getTypeName() {
        checkUpToDate();
        if (!elementsInited) {
            initASTElements();
        }
        return typeName;
    }

    private void _setTypeName(TypeReference typeName, TypeRef typeRef) {
        if (!disableChanges) {
            objectChanged(CHANGED_TYPE);
            changeChild(getTypeName(), typeName);
            this.typeName = typeName;
        }
        setTypeRef(typeRef);
    }

    public void setTypeName(TypeReference typeName) {
        _setTypeName(typeName, typeReferenceToTypeRef(typeName, 0));
    }

    protected void resetChildren() {
        super.resetChildren();
        if (childrenInited) {
            resetASTElements();
            initChildren();
        }
    }

    public int getModifiers() {
        ClassDefinition cd = getDeclaringClass();
        int mods = super.getModifiers();
        if (cd instanceof JavaClass && ((JavaClass)cd).isInterface()) {            
            return mods | Modifier.STATIC | Modifier.FINAL;
        } else {
            return mods;
        }
    }
    
    protected void initASTElements() {
        elementsInited = false;
        if (!childrenInited) {
            initChildren();
        }
        ElementInfo info = getElementInfo();
        ASTree tree = info.getTypeAST(this);
        typeName = (TypeReference) initOrCreate(typeName, tree);
        elementsInited = true;
    }
    
    protected void matchPersistent(ElementInfo info) {
        super.matchPersistent(info);        
        FieldGroupInfo fgInfo = (FieldGroupInfo)info;
        
        if (!isPersisted()) {
            setPersisted(true);
            persist();
            setTypeRef(fgInfo.type);
            persistChildren(getPersistentList("annotations", super_getAnnotations()), ((FeatureInfo) info).annotations);
            persistChildren(getPersistentList(FIELDS_ATTR, super_getFields()), fgInfo.fields);
        } else {
            if (!Utilities.compareObjects(fgInfo.type, getTypeRef())) {
                setTypeRef(fgInfo.type);
            }
            processMembers(getAnnotations(), fgInfo.annotations);
            processMembers(getFields(), fgInfo.fields);
        }
    }
    
    protected void matchElementInfo(ElementInfo newInfo) {
        super.matchElementInfo(newInfo);
        resetASTElements();
    }
    
    public void replaceChild(Element oldElement, Element newElement) {
        if (isPersisted()) {
            if (replaceObject(getFields(), oldElement, newElement)) return;
        }
        if (elementsInited && oldElement.equals(typeName)) {
            setTypeName((MultipartId) newElement);
            return;
        }
        super.replaceChild(oldElement, newElement);
    }
    
    protected void resetASTElements() {
        if (elementsInited) {
            if (typeName != null) {
                TypeReference temp = typeName;
                typeName = null;
                changeChild(temp, null);
                temp.refDelete();
            }
            elementsInited = false;
        }
    }

    protected List getInitedChildren() {
        List list = super.getInitedChildren();
        if (childrenInited) {
            list.addAll(fields);
        }
        if (elementsInited) {
            addIfNotNull(list, typeName);
        }
        return list;
    }

    public List getFields() {
        checkUpToDate();
        if (fields == null) {
            fields = createChildrenList(FIELDS_ATTR, (AttrListWrapper) super_getFields(), null, CHANGED_FEATURES);
        }
        return fields;
    }
    
    List getPersistentFields() {
        AttrListWrapper result = (AttrListWrapper) super_getFields();
        result.setAttrName("fields"); // NOI18N
        return result;
    }

    void reinitFields() {
        if (fields != null) {
            fields.setInnerList(super_getFields());
        }
    }
    
    public List getChildren() {
        List result = super.getChildren();
        addIfNotNull(result, getTypeName());
        result.addAll(getFields());
        return result;
    }

    /**
     * Creates text representation of this object, e.g. 'public int a, b;' for
     * the group of two fields a and b with type int and modifier public.
     */
    String getRawText() {
        StringBuffer buf = new StringBuffer();
        generateNewJavaDoc(buf);
        generateNewModifiers(buf);
        if (getTypeName() != null) {
            buf.append(((MetadataElement) getTypeName()).getSourceText());
        } else {
            buf.append(getType().getName());
        }
        buf.append(' '); // NOI18N

        for (Iterator fieldIt = getFields().iterator(); fieldIt.hasNext(); ) {
            FieldImpl f = (FieldImpl) fieldIt.next();
            buf.append(f.getSourceText());
            if (fieldIt.hasNext())
                formatElementPart(COMMA, buf);
            else
                break;
        }
        buf.append(';'); // NOI18N
        return buf.toString();
    }

    public void getDiff(List diffList) {
        ASTProvider parser = getParser();
        ASTree tree = getASTree();
        ASTree[] children = tree.getSubTrees();

        // javadoc print
        replaceJavaDoc(diffList);
        // modifier print
        if (isChanged(CHANGED_MODIFIERS) || isChanged(CHANGED_ANNOTATION)) {
            diffModifiers(diffList, children[TYPE], parser);
        } else if (children[0] != null) {
            FieldGroupInfo astInfo=(FieldGroupInfo)getElementInfo();

            getCollectionDiff(diffList, parser, CHANGED_ANNOTATION, astInfo.annotations, getAnnotations(), parser.getToken(children[0].getLastToken()).getEndOffset(), " "); // NOI18N
        }
        // type print
        getChildDiff(diffList, parser, children[TYPE], (MetadataElement) getTypeName(), CHANGED_TYPE);
        // name print

        getCollectionDiff(diffList, parser, CHANGED_FEATURES, ((FieldGroupInfo) getElementInfo()).fields,
                getFields(), parser.getToken(tree.getLastToken()).getStartOffset(), formatElementPart(COMMA));
    }

    protected String getIndentation() {
        return ((MetadataElement) refImmediateComposite()).getIndentation().concat(INDENTATION);
    }

    // useful constants
    private static final int TYPE = 1;

    protected ElementInfo getDefaultInfo() {
        return DEFAULT_INFO;
    }

    private List getNakedFeatures() {
        try {
            return (List) ((StorableObject) _getDelegate()).getAttribute(FIELDS_ATTR); // NOI18N
        } catch (StorageException e) {
            throw (GeneralException) ErrorManager.getDefault().annotate(new GeneralException(e.getMessage()), e);
        }
    }

    protected abstract List super_getFields();

    public List getPersistentFeatures() {
        AttrListWrapper list = (AttrListWrapper) super_getFields();
        list.setAttrName(FIELDS_ATTR); // NOI18N
        return list;
    }

    protected void initChildren() {
        // initialization of fields requires writable lock
        boolean fail = true;
        _lock(true);
        try {
            childrenInited = false;
            fields = createChildrenList(fields, FIELDS_ATTR, (AttrListWrapper) super_getFields(), ((FieldGroupInfo) getElementInfo()).fields, CHANGED_FEATURES);
            childrenInited = true;

            if (elementsInited) {
                initASTElements();
            }
            fail = false;
        } finally {
            // I do not need to set featuresInitialized to false in
            // case fail == true, since rollback will follow, thus the
            // reset method that already does that will be invoked
            _unlock(fail);
        }
    }

    void setData(TypeReference typeName, List fields) {
        this.fields = createChildrenList(FIELDS_ATTR, (AttrListWrapper) super_getFields(), fields, CHANGED_FEATURES);
        changeChild(null, typeName);
        this.typeName = typeName;
        elementsInited = true;
        childrenInited = true;
    }

    protected void _delete() {
        deleteChildren(FIELDS_ATTR, (AttrListWrapper) super_getFields());
        if (elementsInited) {
            deleteChild(typeName);
        }
        super._delete();
    }
    
    public Element duplicate(JavaModelPackage targetExtent) {
        return targetExtent.getFieldGroup().createFieldGroup(
                getName(),
                duplicateList(getAnnotations(), targetExtent),
                getModifiers(),
                null, 
                (JavaDoc) duplicateElement(getJavadoc(), targetExtent),
                (TypeReference) duplicateElement(getTypeName(), targetExtent),
                duplicateList(getFields(), targetExtent)
               );
                
    }
}
