/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.modules.javacore.jmiimpl.javamodel;

import java.util.List;
import org.netbeans.jmi.javamodel.Element;
import org.netbeans.jmi.javamodel.FloatLiteral;
import org.netbeans.jmi.javamodel.JavaModelPackage;
import org.netbeans.jmi.javamodel.PrimitiveTypeKindEnum;
import org.netbeans.lib.java.parser.Token;
import org.netbeans.mdr.storagemodel.StorableObject;

/**
 *
 * @author  Martin Matula
 */
public abstract class FloatLiteralImpl extends LiteralImpl implements FloatLiteral {
    private float value;
    
    /** Creates a new instance of FloatLiteralImpl */
    public FloatLiteralImpl(StorableObject o) {
        super(o);
        type = ((JavaModelPackage) refImmediatePackage()).getType().resolve(PrimitiveTypeKindEnum.FLOAT.toString());
    }

    public void setValue(float value) {
        objectChanged(CHANGED_VALUE);
        this.value = value;
    }
    
    public float getValue() {
        if (isChanged(CHANGED_VALUE)) {
            return value;
        } else {
            return ((Float) ((Token) getASTree()).getValue()).floatValue();
        }
    }
    
    public String getSourceText() {
        String origElem;
        if ((origElem = checkChange()) != null)
            return origElem;
        return String.valueOf(getValue())+'f';
    }
    
    public void getDiff(List diff) {
        if (isChanged(CHANGED_VALUE)) {
            replaceNode(diff, getParser(), getASTree(), String.valueOf(getValue())+'f', 0, null);
        }
    }
    
    void setData(float value) {
        this.value = value;
    }
    
    public Element duplicate(JavaModelPackage targetExtent) {
        return targetExtent.getFloatLiteral().createFloatLiteral(getValue());
    }
}
