/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.modules.javacore.jmiimpl.javamodel;

import java.util.List;
import org.netbeans.jmi.javamodel.*;
import org.netbeans.mdr.storagemodel.StorableClass;


/**
 *
 * @author  mm109185
 */
public abstract class ForStatementClassImpl extends MEFactory implements ForStatementClass {
    
    /** Creates a new instance of ForStatementClassImpl */
    public ForStatementClassImpl(StorableClass s) {
        super(s);
    }
    
    /**
     * The default factory operation used to create an instance object.
     * @return The created instance object.
     */
    public ForStatement createForStatement() {
        return create(null, null, null, null);
    }
    
    private ForStatementImpl create(Expression expression, List steps, Statement body, List init) {
        ForStatementImpl result = (ForStatementImpl) create(null);
        result.setNew();
        result.setData(expression, steps, body, init);
        return result;
    }
    
    public ForStatement createForStatement(Expression expression, List steps, Statement body, List init) {
        return create(expression, steps, body, init);
    }
}
