/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.modules.javacore.jmiimpl.javamodel;

import java.util.ArrayList;
import org.netbeans.jmi.javamodel.Element;
import org.netbeans.jmi.javamodel.Expression;
import org.netbeans.jmi.javamodel.ForStatement;
import org.netbeans.jmi.javamodel.Statement;
import org.netbeans.lib.java.parser.ASTree;
import org.netbeans.lib.java.parser.ASTreeTypes;
import org.netbeans.mdr.storagemodel.StorableObject;
import org.netbeans.modules.javacore.parser.ASTProvider;
import java.util.Iterator;
import java.util.List;
import org.netbeans.jmi.javamodel.JavaModelPackage;

/**
 * Instances of element represent for loop in java source. They contain
 * several attributes:
 * <code>
 * for (init; condition; steps)
 *    body;
 * </code>
 * Init, condition, steps and body represent children of this object. The 
 * expressions are available by calling getInit(), getExpression() from 
 * superclass and getSteps(). Getters can return null. Body is represented by 
 * Statement or by StatementBlock instance.
 *
 * @see ForEachStatementImpl
 * 
 * @author  Martin Matula
 */
public abstract class ForStatementImpl extends ConditionImpl implements ForStatement {
    private Statement body = null;
    private LightAttrList steps = null;
    private LightAttrList init = null;
    
    /** Creates a new instance of ForStatementImpl */
    public ForStatementImpl(StorableObject o) {
        super(o);
    }
    
    public List getSteps() {
        if (!childrenInited) {
            initChildren();
        }
        return steps;
    }
    
    public List getInit() {
        if (!childrenInited) {
            initChildren();
        }
        return init;
    }
    
    public void setBody(Statement body) {
        objectChanged(CHANGED_BODY);
        changeChild(getBody(), body);
        this.body = body;
    }

    protected void initChildren() {
        childrenInited = false;
        ASTree tree = getASTree();
        if (tree != null) {
            ASTree[] parts = tree.getSubTrees();
            init = createChildrenList(init, "init", parts[0], ASTreeTypes.STATEMENT_EXPRESSION_LIST, CHANGED_INIT, false); // NOI18N
            expression = (Expression) initOrCreate(expression, parts[1]);
            steps = createChildrenList(steps, "steps", parts[2], ASTreeTypes.STATEMENT_EXPRESSION_LIST, CHANGED_STEPS, false); // NOI18N
            body = (Statement) initOrCreate(body, parts[3]);
        }
        childrenInited = true;
    }
    
    public Statement getBody() {
        if (!childrenInited) {
            initChildren();
        }
        return body;
    }
    
    String getRawText() {
        StringBuffer buf = new StringBuffer();
        StatementImpl cond = (StatementImpl)getExpression();
        StatementImpl body = (StatementImpl) getBody();
        List init = getInit();
        List steps = getSteps();
        
        formatElementPart(FOR_KEYWORD, buf);
        formatElementPart(STMT_OPEN_BRACKET, buf);
        Iterator iter = init.iterator();
        while (iter.hasNext()) {
            StatementImpl expr = (StatementImpl) iter.next();
            buf.append(expr.getSourceText());
            if (iter.hasNext())
                formatElementPart(MetadataElement.COMMA, buf);
        }
        formatElementPart(FOR_SEMICOLON, buf);
        if (cond != null) {
            buf.append(cond.getSourceText());
        }
        formatElementPart(FOR_SEMICOLON, buf);
        iter = getSteps().iterator();
        while (iter.hasNext()) {
            StatementImpl expr = (StatementImpl) iter.next();
            buf.append(expr.getSourceText());
            if (iter.hasNext()) {
                formatElementPart(MetadataElement.COMMA, buf);
            }
        }
        formatElementPart(STMT_CLOSE_BRACKET, buf);
        buf.append(body.getSourceText());
        return buf.toString();
    }

    public void getDiff(List diff) {
        ASTProvider parser = getParser();
        ASTree tree = getASTree();
        ASTree[] children = tree.getSubTrees();

        int endTokens[] = new int[3];
        for (int i = 3; i > 0; i--) {
            if (children[i] == null) {
                endTokens[i - 1] = endTokens[i] - 1;
            } else {
                endTokens[i - 1] = children[i].getFirstToken() - 1;
            }
        }
        getCollectionDiff(diff, parser, CHANGED_INIT, children[0], ASTreeTypes.STATEMENT_EXPRESSION_LIST, getInit(), parser.getToken(endTokens[0]).getStartOffset(), formatElementPart(MetadataElement.COMMA));
        getChildDiff(diff, parser, children[1], (MetadataElement) getExpression(), CHANGED_EXPRESSION, parser.getToken(endTokens[1]).getStartOffset(), "");
        getCollectionDiff(diff, parser, CHANGED_STEPS, children[2], ASTreeTypes.STATEMENT_EXPRESSION_LIST, getSteps(), parser.getToken(endTokens[2]).getStartOffset(), formatElementPart(MetadataElement.COMMA));
        getChildDiff(diff, parser, children[3], (MetadataElement) getBody(), CHANGED_BODY);
    }
        
    void setData(Expression expression, List steps, Statement body, List init) {
        // expression
        changeChild(null, expression);
        this.expression = expression;
        // steps
        this.steps = createChildrenList("steps", steps, CHANGED_STEPS); // NOI18N
        // body
        changeChild(null, body);
        this.body = body;
        // init
        this.init = createChildrenList("init", init, CHANGED_INIT); // NOI18N
    }

    protected void _delete() {
        // --- delete components -------------------------------------------
        if (childrenInited) {
            deleteChildren(steps);
            deleteChild(body);
            deleteChildren(init);
        }
        // --- delete links -----------------------------------------------
        // no links to delete
        // --- call super ---------------------------------------
        super._delete();
    }
    
    public void replaceChild(Element oldElement,Element newElement) {
        if (childrenInited) {
            if (oldElement.equals(body)) {
                setBody((Statement)newElement);
            } else if (replaceObject(getInit(),oldElement,newElement))
                ;
            else if (replaceObject(getSteps(),oldElement,newElement))
                ;
            else
                super.replaceChild(oldElement,newElement);
        }
    }
    
    public List getChildren() {
        List list = new ArrayList(4);
        list.addAll(getInit()); 
        list.addAll(super.getChildren());
        list.addAll(getSteps()); 
        addIfNotNull(list, getBody()); 
        return list;
    }
    
    public Element duplicate(JavaModelPackage targetExtent) {
        return targetExtent.getForStatement().createForStatement(
                (Expression) duplicateElement(getExpression(), targetExtent),
                duplicateList(getSteps(), targetExtent),
                (Statement) duplicateElement(getBody(), targetExtent),
                duplicateList(getInit(), targetExtent)
               );
    }
}
