/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.modules.javacore.jmiimpl.javamodel;

import org.netbeans.jmi.javamodel.Expression;
import org.netbeans.jmi.javamodel.IfStatement;
import org.netbeans.jmi.javamodel.IfStatementClass;
import org.netbeans.jmi.javamodel.Statement;
import org.netbeans.mdr.storagemodel.StorableClass;

/**
 *
 * @author  mm109185
 */
public abstract class IfStatementClassImpl extends MEFactory implements IfStatementClass {
    
    /** Creates a new instance of IfStatementClassImpl */
    public IfStatementClassImpl(StorableClass s) {
        super(s);
    }
    
    /**
     * The default factory operation used to create an instance object.
     * @return The created instance object.
     */
    public IfStatement createIfStatement() {
        return create(null, null, null);
    }
    
    private IfStatementImpl create(Expression expression, Statement thenPart, Statement elsePart) {
        IfStatementImpl result = (IfStatementImpl) create(null);
        result.setNew();
        result.setData(expression, thenPart, elsePart);
        return result;
    }
    
    public IfStatement createIfStatement(Expression expression, Statement thenPart, Statement elsePart) {
        return create(expression, thenPart, elsePart);
    }
}
