/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.modules.javacore.jmiimpl.javamodel;

import org.netbeans.jmi.javamodel.Expression;
import org.netbeans.jmi.javamodel.IfStatement;
import org.netbeans.jmi.javamodel.Statement;
import org.netbeans.lib.java.parser.ASTree;
import org.netbeans.mdr.storagemodel.StorableObject;
import org.netbeans.modules.javacore.parser.ASTProvider;
import java.util.List;
import org.netbeans.jmi.javamodel.Element;
import org.netbeans.jmi.javamodel.JavaModelPackage;

/**
 *
 * @author  Martin Matula
 */
public abstract class IfStatementImpl extends ConditionImpl implements IfStatement {
    private Statement thenPart = null;
    private Statement elsePart = null;
    
    /** Creates a new instance of IfStatementImpl */
    public IfStatementImpl(StorableObject o) {
        super(o);
    }
    
    public void setThenPart(Statement body) {
        objectChanged(CHANGED_THEN_PART);
        changeChild(getThenPart(), body);
        this.thenPart = body;
    }

    public void setElsePart(Statement body) {
        objectChanged(CHANGED_ELSE_PART);
        changeChild(getElsePart(), body);
        this.elsePart = body;
    }

    public List getChildren() {
        List list = super.getChildren();
        addIfNotNull(list, getThenPart()); 
        addIfNotNull(list, getElsePart()); 
        return list;
    }
    
    protected void initChildren() {
        childrenInited = false;
        ASTree tree = getASTree();
        if (tree != null) {
            ASTree[] parts = tree.getSubTrees();
            expression = (Expression) initOrCreate(expression, parts[0]);
            thenPart = (Statement) initOrCreate(thenPart, parts[1]);
            elsePart = (Statement) initOrCreate(elsePart, parts[2]);
        }
        childrenInited = true;
    }
    
    public Statement getThenPart() {
        if (!childrenInited) {
            initChildren();
        }
        return thenPart;
    }
    
    public Statement getElsePart() {
        if (!childrenInited) {
            initChildren();
        }
        return elsePart;
    }

    String getRawText() {
        boolean nju = getASTree() == null;
        StringBuffer buf = new StringBuffer();
        StatementImpl cond = (StatementImpl) getExpression();
        StatementImpl thenPart = (StatementImpl) getThenPart();
        StatementImpl elsePart = (StatementImpl) getElsePart();
        formatElementPart(IF_KEYWORD, buf);
        formatElementPart(STMT_OPEN_BRACKET, buf);
        buf.append(cond.getSourceText());
        formatElementPart(STMT_CLOSE_BRACKET, buf);
        buf.append(thenPart.getSourceText());
        if (elsePart != null) {
            if (!nju)
                IndentUtil.reformatHeadGarbage(this, thenPart.getASTree().getLastToken()+1, buf);
            formatElementPart(ELSE_KEYWORD, buf, nju);
            buf.append(elsePart.getSourceText());
        }
        return buf.toString();
    }
        
    public void getDiff(List diff) {
        ASTProvider parser = getParser();
        ASTree tree = getASTree();
        ASTree[] children = tree.getSubTrees();

        getChildDiff(diff, parser, children[0], (MetadataElement) getExpression(), CHANGED_EXPRESSION);
        getChildDiff(diff, parser, children[1], (MetadataElement) getThenPart(), CHANGED_THEN_PART);
        getChildDiff(diff, parser, children[2], (MetadataElement) getElsePart(), CHANGED_ELSE_PART, parser.getToken(children[1].getLastToken()).getEndOffset(), formatElementPart(ELSE_KEYWORD));
    }
    
    void setData(Expression expression, Statement thenPart, Statement elsePart) {
        changeChild(null, expression);
        changeChild(null, thenPart);
        changeChild(null, elsePart);
        this.expression = expression;
        this.thenPart = thenPart;
        this.elsePart = elsePart;
    }

    protected void _delete() {
        // --- delete components -------------------------------------------
        if (childrenInited) {
            deleteChild(thenPart);
            deleteChild(elsePart);
        }
        // --- delete links -----------------------------------------------
        // no links to delete
        // --- call super ---------------------------------------
        super._delete();
    }
    
    public void replaceChild(Element oldElement,Element newElement) {
        if (childrenInited) {
            if (oldElement.equals(thenPart)) {
                setThenPart((Statement)newElement);
            } else if (oldElement.equals(elsePart)) {
                setElsePart((Statement)newElement);
            } else
                super.replaceChild(oldElement,newElement);
        }
    }
    
    public Element duplicate(JavaModelPackage targetExtent) {
        return targetExtent.getIfStatement().createIfStatement(
                (Expression) duplicateElement(getExpression(), targetExtent), 
                (Statement) duplicateElement(getThenPart(), targetExtent),
                (Statement) duplicateElement(getElsePart(), targetExtent)
               );
    }
}
