/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.modules.javacore.jmiimpl.javamodel;

import org.netbeans.jmi.javamodel.Import;
import org.netbeans.jmi.javamodel.ImportClass;
import org.netbeans.jmi.javamodel.MultipartId;
import org.netbeans.mdr.persistence.StorageException;
import org.netbeans.mdr.storagemodel.StorableBaseObject;
import org.netbeans.mdr.storagemodel.StorableClass;
import org.netbeans.mdr.storagemodel.StorableObject;
import org.netbeans.mdr.util.DebugException;

/**
 *
 * @author Martin Matula
 */
public abstract class ImportClassImpl extends SemiPersistentClass implements ImportClass {
    /** Creates a new instance of PackageClassImpl */
    public ImportClassImpl(StorableClass s) {
        super(s);
    }
    
    public Import createImport(java.lang.String name, MultipartId identifier, boolean isStatic, boolean isOnDemand) {
        ImportImpl i = create(name, identifier, isStatic, isOnDemand, null);
        i.setNew();
        return i;
    }
    
    public Import createImport() {
        ImportImpl i = create(null, null, false, false, null);
        i.setNew();
        return i;
    }
    
    ImportImpl create(String name, MultipartId identifier, boolean isStatic, boolean isOnDemand ,ResourceImpl parent) {
        try {
            // [TODO] better unify immediate package and class proxy
            StorableBaseObject s = _getDelegate();
            DeferredObject o = new DeferredObject(null, s.getMdrStorage(), s.getImmediatePackageId(), s.getOutermostPackageId(), s.getMetaObject(), (StorableClass) s, parent == null ? null : (StorableObject) parent._getDelegate());
            ImportImpl result = (ImportImpl) _getRepository().getHandler(o);
            result.setData(name, isOnDemand, isStatic, identifier);
            return result;
        } catch (StorageException e) {
            throw new DebugException();
        }
    }
}
