/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.modules.javacore.jmiimpl.javamodel;

import org.netbeans.jmi.javamodel.Initializer;
import org.netbeans.jmi.javamodel.StatementBlock;
import org.netbeans.lib.java.parser.ASTree;
import org.netbeans.mdr.storagemodel.StorableObject;
import org.netbeans.modules.javacore.parser.ASTProvider;
import org.netbeans.modules.javacore.parser.ElementInfo;
import org.netbeans.modules.javacore.parser.FeatureInfo;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.netbeans.jmi.javamodel.Element;
import org.netbeans.jmi.javamodel.JavaDoc;
import org.netbeans.jmi.javamodel.JavaModelPackage;
import org.netbeans.modules.javacore.JMManager;

/**
 *
 * @author  Martin Matula
 * @author  Pavel Flaska
 */
public abstract class InitializerImpl extends BehavioralFeatureImpl implements Initializer {
    private static final ElementInfo DEFAULT_INFO = new FeatureInfo(null, FeatureInfo.STATIC_INITIALIZER_TYPE, null, 0, null);
    
    /** Creates a new instance of InitializerImpl */
    public InitializerImpl(StorableObject s) {
        super(s);
    }

    protected ElementInfo getDefaultInfo() {
        return DEFAULT_INFO;
    }

    protected void matchName(ElementInfo info) {
        // do not match name
    }

    public String getName() {
        return null;
    }

    public void setName(String name) {
        // initializer does not have a name
        throw new UnsupportedOperationException();
    }

    protected ASTree getBodyAST() {
        return getASTree().getSubTrees()[1];
    }

    public Collection getReferences() {
        return Collections.EMPTY_LIST;
    }

    protected void initChildren() {
        childrenInited = true;
        StatementBlock body = retrieveBody();
        if (bodyInited) {
            JMManager.getTransactionMutex().addBFeatureToInitQueue(this);
        }
    }

    public String getSourceText() {
        String origElem;
        if ((origElem = checkChange()) != null)
            return origElem;
        // we have element which is new or changed and moved.
        // todo (#pf): it is possible to leave formatting and comments section
        // as they are in the original element if the element is regenerated.
        // Because it is only rare case, we do not solve it now.    }
        StringBuffer buf = new StringBuffer();
        String indent = getIndentation();
        buf.append('\n');
        buf.append(indent);
        int modifiers = getSourceModifiers();
        if ((modifiers & ~Modifier.STATIC) != modifiers) {
            buf.append(Modifier.toString(modifiers));
        }
        generateBody(buf);
        return buf.toString();
    }

    public void getDiff(List diffList) {
        ASTProvider parser = getParser();
        ASTree tree = getASTree();

        // modifier print
        if (isChanged(CHANGED_MODIFIERS)) {
            boolean isStatic = (getSourceModifiers() & Modifier.STATIC) == Modifier.STATIC ? true : false;
            int startOffset = parser.getToken(tree.getFirstToken()).getStartOffset();
            if (isStatic) {
                // add static modifier
                String mods = Modifier.toString(getSourceModifiers());
                mods += ' ';
                diffList.add(new DiffElement(startOffset, startOffset, mods));
            }
            else {
                // delete static modifier
                int endOffset = parser.getToken(tree.getFirstToken()+1).getStartOffset();
                diffList.add(new DiffElement(startOffset, endOffset, ""));
            }
        }
        // body print
        createBodyDiffs(diffList);
    }
    
    public Element duplicate(JavaModelPackage targetExtent) {
        StatementBlock body;
        String bodyText;
        
        if (isChanged(CHANGED_BODY) && this.bodyText != null) {
            body = null;
            bodyText = this.bodyText;
        } else {
            body = (StatementBlock) duplicateElement(getBody(), targetExtent);
            bodyText = null;
        }
        
        return targetExtent.getInitializer().createInitializer(
                null,
                duplicateList(getAnnotations(), targetExtent),
                getModifiers(), 
                null,
                (JavaDoc) duplicateElement(getJavadoc(), targetExtent),
                body,
                bodyText
            );
    }
}
