/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.modules.javacore.jmiimpl.javamodel;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.lang.ref.Reference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;

/**
 *
 * @author  Martin Matula
 */
public class InstanceMap extends HashMap {
    private final ReferenceQueue queue = new ReferenceQueue();

    private class InstanceReference extends WeakReference {
        private Object key;

        public InstanceReference(Object key, Object instance) {
            super(instance, queue);
            this.key = key;
        }

        public Object getKey() {
            return key;
        }
    }

    private void cleanUp() {
        InstanceReference reference;

        while ((reference = (InstanceReference) queue.poll()) != null) {
            Object key = reference.getKey();
            Reference currentRef = (Reference) super.remove(key);
            if (currentRef != null && currentRef != reference && currentRef.get() != null) {
                super.put(key, currentRef);
            }
        }
    }

    public Object put(Object key, Object value) {
        cleanUp();
        Object result = super.put(key, new InstanceReference(key, value));
        if (result != null) {
            return ((InstanceReference) result).get();
        } else {
            return result;
        }
    }

    public Object get(Object key) {
        cleanUp();
        Object result = super.get(key);
        if (result != null) {
            return ((InstanceReference) result).get();
        } else {
            return result;
        }
    }
    
    public Collection values() {
        ArrayList result = new ArrayList();
        cleanUp();
        for (Iterator it = super.values().iterator(); it.hasNext();) {
            result.add(((InstanceReference) it.next()).get());
        }
        return result;
    }
}
