/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.modules.javacore.jmiimpl.javamodel;

import java.util.*;
import org.netbeans.jmi.javamodel.Element;
import org.netbeans.mdr.storagemodel.StorableObject;

/**
 *
 * @author Martin Matula
 */
public abstract class InvocationImpl extends ElementReferenceImpl {
    protected LightAttrList parameters = null;
    
    /** Creates a new instance of InvocationImpl */
    public InvocationImpl(StorableObject o) {
        super(o);
    }
    
    public List getParameters() {
        if (!childrenInited) {
            initChildren();
        }
        return parameters;
    }
    
    void setData(String name, List parameters) {
        setData(name);
        this.parameters = createChildrenList("parameters", parameters, CHANGED_PARAMETERS); // NOI18N
    }      
    
    protected void _delete() {
        // --- delete components -------------------------------------------
        if (childrenInited) {
            deleteChildren(parameters);
        }
        // --- delete links -----------------------------------------------
        // no links to delete
        // --- call super ---------------------------------------
        super._delete();
    }
    
    public List getChildren() {
        return new ArrayList(getParameters());
    }
    
    public void replaceChild(Element oldElement,Element newElement) {
        replaceObject(getParameters(),oldElement,newElement);
    }
    
    public String getSourceText() {
        return getRawText();
    }
}
