/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.modules.javacore.jmiimpl.javamodel;

import java.util.ArrayList;
import java.util.List;
import org.netbeans.jmi.javamodel.Element;
import org.netbeans.jmi.javamodel.JavaDoc;
import org.netbeans.jmi.javamodel.JavaModelPackage;
import org.netbeans.lib.java.parser.Token;
import org.netbeans.mdr.storagemodel.StorableObject;
import org.netbeans.modules.javacore.parser.ASTProvider;
import org.netbeans.modules.javacore.parser.MDRParser;
import org.openide.text.PositionBounds;

/**
 * Implementation of JavaDoc object instance interface.
 *
 * @author Vladimir Hudec
 */
public abstract class JavaDocImpl extends MetadataElement implements JavaDoc {

    protected String text = null;
    protected List tags = null;

    private boolean isNew = false;
    protected boolean childrenInited = false;


    protected JavaDocImpl(StorableObject s) {
        super(s);
    }

    protected final boolean isInitialized() {
        return isNew;
    }

    /** Overriding methods must call super.setNew() */
    protected void setNew() {
        setChanged();
        isNew = true;
        childrenInited = true;
    }

    protected final boolean isNew() {
        return isNew;
    }

    public List getChildren() {
        return new ArrayList(getTags());
    }
    
    public PositionBounds getPosition(boolean inclDoc) {
        testResourceChange();
        FeatureImpl feature=(FeatureImpl)refImmediateComposite();        
        ASTProvider p=feature.getParser();
        Token javadocToken=p.getComment(feature.getASTree());

        return p.createBounds(javadocToken.getStartOffset(), javadocToken.getEndOffset());
    }
    
    /**
     * Returns the value of attribute text.
     * @return Value of attribute text.
     */
    public String getText() {
        return text;
    }

    /**
     * Sets the value of text attribute. See {@link #getText} for description
     * on the attribute.
     * @param newValue New value to be set.
     */
    public void setText(String newValue) {
        objectChanged(CHANGED_JAVADOC);
        this.text = newValue;
    }

    /**
     * Returns the value of attribute tags.
     * @return Value of tags attribute.
     */
    public List getTags() {
        return tags;
    }

    void setData(String text, List tags) {
        this.text = text;
        this.tags = createChildrenList("tags", tags, CHANGED_JAVADOC); // NOI18N
    }

    protected java.lang.Object getInternalForm() {
        return text;
    }

    /** Part ot the rollback mechanism.
     *
     * In the case of any rollback, all classes should be rebuilt from ASTrees.
     * The layout for method is the next one:
     * protected void reset() {
     *   .. do your own job...
     *   super.reset()
     * }
     */
    protected final void rollback() {
        // TODO: implement me
    }
    
    public MDRParser getParser() {
        return null;
    }
    
    public Element duplicate(JavaModelPackage targetExtent) {
        return targetExtent.getJavaDoc().createJavaDoc(getText(), duplicateList(getTags(), targetExtent));
    }
}
