/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.modules.javacore.jmiimpl.javamodel;

import java.util.Collection;
import java.util.Collections;
import javax.jmi.reflect.ConstraintViolationException;
import org.netbeans.jmi.javamodel.Type;
import org.netbeans.mdr.storagemodel.StorableObject;

/**
 *
 * @author  VladimirHudec
 */
public abstract class LiteralImpl extends ExpressionImpl {
    protected Type type;
    
    /** Creates a new instance of ExpressionImpl */
    public LiteralImpl(StorableObject o) {
        super(o);
    }
    
    /**
     * Returns the value of reference type.
     * @return Value of reference type.
     */
    public Type getType() {
        return type;
    }

    /**
     * Sets the value of reference type. See {@link #getType} for description 
     * on the reference.
     * @param newValue New value to be set.
     */
    public void setType(Type newValue) {
        throw new ConstraintViolationException(this, null, "Literal type is readonly."); // NOI18N
    }
}
