/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.modules.javacore.jmiimpl.javamodel;

import org.netbeans.lib.java.parser.ASTree;
import org.netbeans.lib.java.parser.ASTreeTypes;
import org.netbeans.lib.java.parser.ParserTokens;
import org.netbeans.mdr.storagemodel.StorableObject;
import org.netbeans.modules.javacore.parser.ASTProvider;
import org.netbeans.modules.javacore.parser.AnnotationInfo;
import org.netbeans.modules.javacore.parser.MDRParser;
import java.util.*;
import org.netbeans.jmi.javamodel.*;
import org.netbeans.mdr.handlers.AttrListWrapper;
import org.netbeans.mdr.handlers.BaseObjectHandler;
import org.netbeans.mdr.persistence.StorageException;
import org.netbeans.mdr.storagemodel.StorableFeatured;
import org.openide.ErrorManager;

/**
 *
 * @author  Martin Matula
 */
public abstract class LocalVarDeclarationImpl extends StatementImpl implements LocalVarDeclaration {
    private LightAttrList variables;
    private boolean isFinal;
    private TypeReference typeName;
    private LightAttrList annotations = null;
    
    /** Creates a new instance of LocalVarDeclarationImpl */
    public LocalVarDeclarationImpl(StorableObject o) {
        super(o);
    }
    
    public boolean isFinal() {
        if (isChanged(CHANGED_IS_FINAL)) {
            return isFinal;
        } else {
            Object[] modInfo=(Object[])getModInfo();
            return ((Boolean)modInfo[0]).booleanValue();
        }
    }

    public void setFinal(boolean isFinal) {
        objectChanged(CHANGED_IS_FINAL);
        this.isFinal = isFinal;
    }
    
    public TypeReference getTypeName() {
        if (!childrenInited) {
            initChildren();
        }
        return typeName;
    }

    public void setTypeName(TypeReference typeName) {
        objectChanged(CHANGED_TYPE);
        changeChild(getTypeName(), typeName);
        this.typeName = typeName;
    }

    public Type getType() {
        return (Type) getTypeName().getElement();
    }
    
    public void setType(Type newValue) {
        MultipartIdClass proxy = ((JavaModelPackage) refImmediatePackage()).getMultipartId();
        setTypeName(proxy.createMultipartId(newValue.getName(), null, null));
    }

    public List getVariables() {
        if (!childrenInited) {
            initChildren();
        }
        return variables;
    }
    
    public List/*<org.netbeans.jmi.javamodel.Annotation>*/ getAnnotations() {
        if (!childrenInited) {
            initChildren();
        }
        return annotations;
    }
    
    public List getChildren() {
        List result = new ArrayList();
        result.addAll(getAnnotations());
        addIfNotNull(result, getTypeName());
        result.addAll(getVariables());
        return result;
    }
    
    protected void initChildren() {
        childrenInited = false;
        ASTree tree = getASTree();
        if (tree != null) {
            AnnotationInfo[] annotInfos = getAnnotInfos();
            typeName = (TypeReference) initOrCreate(typeName, tree.getSubTrees()[1]);
            variables = createChildrenList(variables, "variables", tree.getSubTrees()[2], ASTreeTypes.VARIABLE_DECLARATORS, CHANGED_VARIABLES, false); // NOI18N
            createChildrenList(annotInfos);
        }
        childrenInited = true;
    }

    public String getRawText() {
        boolean useSemicolon = !(refImmediateComposite() instanceof ForStatement);
        if (!isNew()) {
            if (!isChanged()) {
                MDRParser parser = getParser();
                ASTree tree = getASTree();
                String origSrc = parser.getSourceText();
                int startIndex, endIndex;
                String semicolon;
                String indentation;
                boolean isSemicolon = parser.getToken(tree.getLastToken()).getType() == ParserTokens.SEMICOLON;
                if (useSemicolon == isSemicolon) {
                    semicolon = indentation = "";
                    startIndex = IndentUtil.getElementStart(this);
                    endIndex = IndentUtil.getElementEnd(this);
                } else {
                    startIndex = getStartOffset(parser, tree, false);
                    if (useSemicolon) {
                        semicolon = ";"; // NOI18N
                        indentation = getIndentation();
                        endIndex = IndentUtil.getElementEnd(this);
                    } else {
                        indentation = semicolon = "";
                        endIndex = getEndOffset(parser, parser.getToken(tree.getLastToken() - 1));
                    }
                }
                return indentation + origSrc.substring(startIndex, endIndex) + semicolon;
            } else {
                if (!childrenInited) {
                    initChildren();
                }
            }
        }
        StringBuffer buf = new StringBuffer(37);
        for (Iterator annIt = getAnnotations().iterator(); annIt.hasNext(); ) {
            AnnotationImpl ann = (AnnotationImpl) annIt.next();
            buf.append(ann.getSourceText()).append('\n').append(getIndentation());
        }
        if (isFinal()) {
            buf.append("final "); // NOI18N
        }
        TypeReference typeName = getTypeName();
        if (typeName != null) {
            buf.append(((MetadataElement) typeName).getSourceText());
        } else {
            buf.append(getType().getName());
        }
        if (((TransientElement) getVariables().get(0)).isNew()) {
            buf.append(' ');
        }
        Iterator iter = getVariables().iterator();
        while (iter.hasNext()) {
            TransientElement var = (TransientElement) iter.next();
            buf.append(var.getSourceText());
            if (iter.hasNext()) {
                formatElementPart(MetadataElement.COMMA, buf);
            }
        }
        if (useSemicolon) {
            buf.append(";");
        }
        return buf.toString();
    }

    public void getDiff(List diff) {
        ASTree tree = getASTree();
        MDRParser parser = (MDRParser) tree.getASTContext();
        ASTree[] children = tree.getSubTrees();
        AnnotationInfo infos[] = getAnnotInfos();

        if (isChanged(CHANGED_IS_FINAL) || isChanged(CHANGED_ANNOTATION)) {
            diffModifiers(diff, children[1], parser);
        } else if (children[0] != null) {
            getCollectionDiff(diff, parser, CHANGED_ANNOTATION, infos, getAnnotations(), parser.getToken(children[0].getLastToken()).getEndOffset(), " "); // NOI18N
        }
        getChildDiff(diff, parser, children[1], (MetadataElement) getTypeName(), CHANGED_TYPE);
        getCollectionDiff(diff, parser, CHANGED_VARIABLES, children[2],
            ASTreeTypes.VARIABLE_DECLARATORS, getVariables(), 
            parser.getToken(children[2].getLastToken()).getEndOffset(), formatElementPart(MetadataElement.COMMA));
    }
    
    void setData(List variables, boolean isFinal, TypeReference typeName) {
        this.variables = createChildrenList("variables", variables, CHANGED_VARIABLES); // NOI18N
        createChildrenList(null);
        this.isFinal = isFinal;
        changeChild(null, typeName);
        this.typeName = typeName;
    }

    protected void _delete() {
        // --- delete components -------------------------------------------
        if (childrenInited) {
            deleteChildren(variables);
            deleteChild(typeName);
        }
        // --- delete links -----------------------------------------------
        // no links to delete
        // --- call super ---------------------------------------
        super._delete();
    }
    
    public void replaceChild(Element oldElement,Element newElement)  {
        if (childrenInited) {
            if (replaceObject(annotations, oldElement, newElement)) return;
            if (replaceObject(variables, oldElement, newElement)) return;
            if (oldElement.equals(typeName)) {
                setTypeName((TypeReference)newElement);
            }
        }
    }

    public Element duplicate(JavaModelPackage targetExtent) {
        LocalVarDeclarationImpl var = (LocalVarDeclarationImpl) targetExtent.getLocalVarDeclaration().createLocalVarDeclaration(
                isFinal(),
                (TypeReference) duplicateElement(getTypeName(), targetExtent), 
                duplicateList(variables, targetExtent)
               );
        var.getAnnotations().addAll(duplicateList(getAnnotations(), targetExtent));
        return var;
    }
    
    // ------------ PRIVATE METHODS --------------------------------------------
    
    protected void diffModifiers(List diffList, ASTree nextNode, ASTProvider parser) {
        String text = "";
        for (Iterator annIt = getAnnotations().iterator(); annIt.hasNext(); ) {
            AnnotationImpl ann = (AnnotationImpl) annIt.next();
            text += ann.getSourceText();
            text += '\n';
            text += getIndentation();
        }
        if (isFinal()) {
            text += "final"; // NOI18N
        }
        int nextToken = nextNode.getFirstToken();
        int startOffset, endOffset;
        int startToken;
        endOffset = parser.getToken(nextToken).getStartOffset();
        ASTree modifiers = getASTree().getSubTrees()[0];
        if (modifiers != null) {
            startToken = modifiers.getFirstToken();
            startOffset = parser.getToken(startToken).getStartOffset();
            if (text.length() > 0) {
                int endToken = modifiers.getLastToken();
                endOffset = parser.getToken(endToken).getEndOffset();
            }
        } else {
            startOffset = endOffset;
            if (isFinal()) {
                text += ' ';
            }
        }
        diffList.add(new DiffElement(startOffset, endOffset, text));
    }

    private void createChildrenList(AnnotationInfo[] infos) {
        DeferredAttrList deferredList;
        try {
            if (annotations != null && infos != null) {
                deferredList = (DeferredAttrList) ((AttrListWrapper) annotations.getInnerList()).getInnerList();
                int i = 0;
                for (ListIterator it = deferredList.listIterator(); it.hasNext(); i++) {
                    AnnotationImpl im = (AnnotationImpl) it.next();
                    if (isNew()) {
                        im.setNew();
                    } else {
                        if (i >= infos.length) {
                            it.remove();
                        } else {
                            im.setElementInfo(infos[i]);
                        }
                    }
                }
                for (; i < infos.length; i++) {
                    deferredList.add(createElement(infos[i]));
                }
            } else {
                JavaModelPackage pkg = (JavaModelPackage) refImmediatePackage();
                StorableFeatured storable = (StorableFeatured) ((BaseObjectHandler) pkg.getLocalVariable())._getDelegate();
                deferredList = new DeferredAttrList((StorableFeatured)_getDelegate(), storable.getClassProxy().getAttrDesc("annotations"), new ArrayList()); // NOI18N
                annotations = createWrapper("annotations", deferredList, CHANGED_ANNOTATION); // NOI18N
                if (deferredList != null && infos != null) {
                    for (int i = 0; i < infos.length; i++) {
                        MetadataElement s = createElement(infos[i]);
                        if (s != null) {
                            deferredList.add(s);
                        }
                    }
                }
            }
        } catch (StorageException e) {
            throw (GeneralException) ErrorManager.getDefault().annotate(new GeneralException(e.getMessage()), e);
        }
    }
    
    private AnnotationInfo[] getAnnotInfos() {
        Object[] modInfo=(Object[])getModInfo();
        AnnotationInfo[] ann=(AnnotationInfo[])modInfo[1];
        return ann == null ? AnnotationInfo.EMPTY_ANNOTATIONS : ann;
    }

    private static final Object[] NO_MODIFIERS=new Object[]{Boolean.FALSE,null};
    
    private Object getModInfo() {
        ASTree tree = getASTree();
        MDRParser parser = (MDRParser) tree.getASTContext();
        ASTree modifiers = tree.getSubTrees()[0];
        return modifiers == null ? NO_MODIFIERS : parser.getSemanticInfo(modifiers, null);
    }
}
