/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.modules.javacore.jmiimpl.javamodel;

import org.netbeans.jmi.javamodel.*;
import org.netbeans.lib.java.parser.ASTree;
import org.netbeans.mdr.storagemodel.StorableObject;
import org.netbeans.modules.javacore.parser.ASTProvider;
import org.netbeans.modules.javacore.parser.ASTUtil;
import org.netbeans.modules.javacore.parser.MDRParser;
import javax.jmi.reflect.ConstraintViolationException;
import java.util.*;

/**
 *
 * @author  Martin Matula
 */
public abstract class LocalVariableImpl extends TransientElement implements LocalVariable {
    private String name;
    private boolean isFinal;
    private InitialValue initialValue;
    private String initialValueText;
    protected Type type;
    private int dimCount;

    /** Creates a new instance of LocalVariableImpl */
    public LocalVariableImpl(StorableObject o) {
        super(o);
    }
    
    public String getName() {
        if (isChanged(CHANGED_NAME)) {
            return name;
        } else {
            return ASTUtil.getIdentifier(getASTree().getSubTrees()[0]);
        }
    }
    
    public void setName(String name) {
        objectChanged(CHANGED_NAME);
        this.name = name;
    }

    public int getDimCount() {
        if (isChanged(CHANGED_DIM_COUNT)) {
            return dimCount;
        } else {
            ASTree dims = getASTree().getSubTrees()[1];
            if (dims == null) {
                return 0;
            } else {
                return (dims.getLastToken() - dims.getFirstToken() + 1) / 2;
            }
        }
    }

    public void setDimCount(int dimCount) {
        objectChanged(CHANGED_DIM_COUNT);
        this.dimCount = dimCount;
    }

    public boolean isFinal() {
        LocalVarDeclarationImpl parent = (LocalVarDeclarationImpl) refImmediateComposite();
        if (parent == null) {
            if (isChanged(CHANGED_IS_FINAL)) {
                return isFinal;
            } else {
                return getASTree().getSubTrees()[0] != null;
            }
        } else {
            return parent.isFinal();
        }
    }
    
    public void setFinal(boolean isFinal) {
        LocalVarDeclarationImpl parent = (LocalVarDeclarationImpl) refImmediateComposite();
        if (parent == null) {
            objectChanged(CHANGED_IS_FINAL);
            this.isFinal = isFinal;
        } else {
            throw new ConstraintViolationException(null, null);
        }
    }
    
    public List getAnnotations() {
        Object parent = refImmediateComposite();
        if (parent instanceof LocalVarDeclarationImpl) {
            return ((LocalVarDeclarationImpl) parent).getAnnotations();
        } else {
            return Collections.EMPTY_LIST;
        }
    }
    
    public InitialValue getInitialValue() {
        if (!childrenInited) {
            initChildren();
        }
        return initialValue;
    }
    
    public void setInitialValue(InitialValue initialValue) {
        objectChanged(CHANGED_INITIAL_VALUE);
        changeChild(getInitialValue(), initialValue);
        this.initialValue = initialValue;
    }

    public TypeReference getTypeName() {
        LocalVarDeclaration composite = (LocalVarDeclaration) refImmediateComposite();
        if (composite != null) {
            return composite.getTypeName();
        }
        return null;
    }

    public void setTypeName(TypeReference typeName) {
        throw new ConstraintViolationException(null, null, "Cannot set typename on LocalVariable."); // NOI18N
    }

    public String getInitialValueText() {
        if (isChanged(CHANGED_INITIAL_VALUE)) {
            return initialValueText;
        } else {
            return extractInitialValueText();
        }
    }
    
    public void setInitialValueText(String initialValueText) {
        objectChanged(CHANGED_INITIAL_VALUE);
        this.initialValueText = initialValueText;
    }
    
    private ASTree extractInitialValue() {
        return getASTree().getSubTrees()[2];
    }
    
    private String extractInitialValueText() {
        MDRParser parser = getParser();
        ASTree initValue = extractInitialValue();
        if (initValue == null)
            return null;
        int firstToken = initValue.getFirstToken();
        int lastToken = initValue.getLastToken();
        return parser.getText(parser.getToken(firstToken), parser.getToken(lastToken));
    }
    
    public List getChildren() {
        List list = new ArrayList(1);
        addIfNotNull(list, getInitialValue());
        return list;
    }
    
    protected void initChildren() {
        childrenInited = false;
        ASTree tree = getASTree();
        if (tree != null) {
            initialValue = (InitialValue) initOrCreate(initialValue, extractInitialValue());
        }
        childrenInited = true;
    }

    /**
     */
    protected ASTree getPartTree(ElementPartKind part) {
        // name
        if (ElementPartKindEnum.NAME.equals(part)) {
            return getASTree().getSubTrees()[0];
        }
        throw new IllegalArgumentException("Invalid part for this element: " + part); // NOI18N
    }
    
    public String getSourceText() {
        StringBuffer buf = new StringBuffer();      
        String name = getName();
        boolean nju = isNew();
        if (!nju) IndentUtil.reformatHeadGarbage(this, buf);
        buf.append(name);
        appendDims(buf, getDimCount());
        String initialValueText = getInitialValueText();
        if (initialValueText != null && initialValueText.trim().length() != 0) {                
            formatElementPart(FIELD_EQUALS, buf);
            buf.append(initialValueText);
        } else {
            TransientElement initialValue = (TransientElement) getInitialValue();
            if (initialValue != null) {
                formatElementPart(FIELD_EQUALS, buf);
                buf.append(initialValue.getSourceText());
            }
        }
        return buf.toString();
    }
    
    public void getDiff(List diff) {
        ASTProvider parser = getParser();
        ASTree tree = getASTree();
        ASTree[] children = tree.getSubTrees();
        
        if (isChanged(CHANGED_NAME)) {
            replaceNode(diff, parser, children[0], getName(), 0, null);
        }
        if (isChanged(CHANGED_DIM_COUNT)) {
            replaceNode(diff, parser, children[1], appendDims(new StringBuffer(), getDimCount()).toString(), getEndOffset(getParser(), children[0]), "");
        }
        if (isChanged(CHANGED_TYPE)) {
            Type type = getType();
            Type parentType = ((LocalVarDeclarationImpl) refImmediateComposite()).getType();
            StringBuffer dims = new StringBuffer();
            while (type != parentType) {
                type = ((Array) type).getType();
                formatElementPart(ARRAY_OPEN_BRACKET, dims);
                formatElementPart(ARRAY_CLOSE_BRACKET, dims);
            }
            replaceNode(diff, parser, children[1], dims.toString(), parser.getToken(children[0].getLastToken()).getEndOffset(), "");
        }
        if (isChanged(CHANGED_INITIAL_VALUE)) {
            int index = children[1] != null ? children[1].getLastToken() : children[0].getLastToken();
            int pos = parser.getToken(index).getEndOffset();
            if (initialValueText == null) {
                getChildDiff(diff, parser, children[2], (MetadataElement) initialValue, CHANGED_INITIAL_VALUE, pos, formatElementPart(FIELD_EQUALS));
            } else {
                replaceNode(diff, parser, children[2], initialValueText, pos, formatElementPart(FIELD_EQUALS));
            }
        } else if (isChanged(CHANGED_CHILDREN)) {
            if (initialValue != null) {
                ((MetadataElement) initialValue).getDiff(diff);
            }
        }
    }
    
    void setData(String name, List annotations, boolean isFinal, int dimCount, InitialValue initialValue, String initialValueText) {
        this.name = name;
        this.isFinal = isFinal;
        changeChild(null, initialValue);
        this.initialValue = initialValue;
        this.initialValueText = initialValueText;
        this.dimCount = dimCount;
    }
    
    protected void _delete() {
        // --- delete components -------------------------------------------
        if (childrenInited) {
            deleteChild(initialValue);
        }
        // --- delete links -----------------------------------------------
        // no links to delete
        // --- call super ---------------------------------------
        super._delete();
    }
    
    public void replaceChild(Element oldElement,Element newElement) {
        if (childrenInited) {
            if (oldElement.equals(initialValue)) {
                setInitialValue((InitialValue)newElement);
            }
        }
    }

    // Interfaces inherited from Variable, StructuralElement
    
    /**
     * Returns the value of reference type.
     * @return Value of reference type.
     */
    public Type getType() {
        if (isChanged(CHANGED_TYPE))
            return type;
        else {
            Type type = ((LocalVarDeclarationImpl) refImmediateComposite()).getType();
            ASTree dims = getASTree().getSubTrees()[1];
            if (dims != null) {
                int d = (dims.getLastToken() - (dims.getFirstToken())) /2 + 1;
                ArrayClass arrClass = ((JavaModelPackage)type.refImmediatePackage()).getArray();
                for (int i = 0; i < d; i++){
                    type = arrClass.resolveArray(type);
                }
            }
            return type;
        }
    }
    
    public Collection getReferences() {
        Resource[] res = new Resource[]{getResource()};
        UsageFinder finder = new UsageFinder(this);
        return finder.getUsers(res);
    }
    public void setType(Type newValue) {
        //System.out.println("LocalVariable._setType: "+((newValue!=null)?newValue.getName():"null"));
//        objectChanged(CHANGED_TYPE);
//        type = newValue;
        throw new ConstraintViolationException(null, null, "Call setType on LocalVarDeclaration to change type of this variable."); // NOI18N
    }
    
    public Element duplicate(JavaModelPackage targetExtent) {
        return targetExtent.getLocalVariable().createLocalVariable(
                getName(), duplicateList(getAnnotations(), targetExtent), isFinal(), 
                (TypeReference) duplicateElement(getTypeName(), targetExtent),
                getDimCount(),
                (InitialValue) duplicateElement(getInitialValue(), targetExtent),
                null
               );
    }
}
