/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.modules.javacore.jmiimpl.javamodel;

import java.util.Arrays;
import java.util.List;
import org.netbeans.jmi.javamodel.*;
import org.netbeans.mdr.storagemodel.StorableClass;
import org.netbeans.modules.javacore.parser.TypeParamRef;
import org.netbeans.modules.javacore.parser.TypeRef;

/**
 * Implementation of Method class proxy interface.
 *
 */
public abstract class MethodClassImpl extends SemiPersistentClass implements MethodClass {
    
    protected MethodClassImpl(StorableClass s) {
        super(s);
    }
    
    /**
     * The default factory operation used to create an instance object.
     * @return The created instance object.
     */
    public Method createMethod() {
        return create(null, null, 0, null, null, null, null, null, null, null, null, 0);
    }
    
    public Method createMethod(java.lang.String name, List annotations, int modifiers, java.lang.String javadocText, JavaDoc javadoc, StatementBlock body, java.lang.String bodyText, List typeArguments, List parameters, List exceptionNames, TypeReference typeName, int dimCount) {
        return create(name, annotations, modifiers, javadocText, javadoc, body, bodyText, typeArguments, parameters, exceptionNames, typeName, dimCount);
    }
    
    private Method create(java.lang.String name, List annotations, int modifiers, java.lang.String javadocText, JavaDoc javadoc, StatementBlock body, java.lang.String bodyText, List typeArguments, List parameters, List exceptionNames, TypeReference typeName, int dimCount) {
        MethodImpl result = create(name, modifiers, null, null, false);
        result.setNew();
        result.setData(annotations, javadocText, javadoc, body, bodyText, typeArguments, parameters, exceptionNames, typeName, dimCount);
        return result;
    }

    public MethodImpl create(String name, int modifiers, TypeRef type, TypeParamRef[] exceptions, boolean isTransient) {
        MethodImpl result;
        if (isTransient) {
            result = (MethodImpl) createTransient();
            boolean changes = result.disableChanges;
            result.disableChanges = true;
            try {
                result.setName(name);
                result.setModifiers(modifiers);
            } finally {
                result.disableChanges = changes;
            }
        } else {
            result = (MethodImpl) super_createMethod(name, null, modifiers, null, null, null, null, null, null, null, null, 0);
        }
        result.setTypeRef(type);
        result.setExceptionRefs(exceptions == null ? null : Arrays.asList(exceptions));
        return result;
    }

    protected abstract Method super_createMethod();
    protected abstract Method super_createMethod(java.lang.String name, List annotations, int modifiers, java.lang.String javadocText, JavaDoc javadoc, StatementBlock body, java.lang.String bodyText, List typeArguments, List parameters, List exceptionNames, TypeReference typeName, int dimCount);
}
