/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.modules.javacore.jmiimpl.javamodel;

import java.util.ArrayList;
import org.netbeans.jmi.javamodel.*;
import org.netbeans.lib.java.parser.ASTree;
import org.netbeans.lib.java.parser.ASTreeTypes;
import org.netbeans.mdr.storagemodel.StorableObject;
import org.netbeans.modules.javacore.internalapi.JavaModelUtil;
import org.netbeans.modules.javacore.parser.ASTProvider;
import org.netbeans.modules.javacore.parser.ClassInfo;
import java.util.Iterator;
import java.util.List;


/**
 *
 * @author  Martin Matula
 */
public abstract class NewClassExpressionImpl extends InvocationImpl implements NewClassExpression {
    private ClassDefinition classDefinition;
    private PrimaryExpression enclosingClass;
    private MultipartId className;

    /** Creates a new instance of NewClassExpressionImpl */
    public NewClassExpressionImpl(StorableObject o) {
        super(o);
    }
    
    public void setEnclosingClass(PrimaryExpression expression) {
        objectChanged(CHANGED_ENCLOSING_CLASS);
        changeChild(getEnclosingClass(), expression);
        this.enclosingClass = expression;
    }
    
    public PrimaryExpression getEnclosingClass() {
        if (!childrenInited) {
            initChildren();
        }
        return enclosingClass;
    }
    
    public Type getType() {
        if (isChanged(CHANGED_TYPE))
            return type;
        else {
            return (Type) getParser().getSemanticInfo(getNameAST(), this);
        }
    }
    
    public void setType(Type type) {
        this.type = type;
        objectChanged(CHANGED_TYPE);
    }
    
    public ClassDefinition getClassDefinition() {
        if (!childrenInited) {
            initChildren();
        }
        return classDefinition;
    }
    
    public void setClassDefinition(ClassDefinition classDefinition) {
        objectChanged(CHANGED_CLASS_DEFINITION);
        changeChild(getClassDefinition(), classDefinition);
        this.classDefinition = classDefinition;
    }
    
    public MultipartId getClassName() {
        if (!childrenInited) {
            initChildren();
        }
        return className;
    }

    public void setClassName(MultipartId className) {
        objectChanged(CHANGED_CLASS_NAME);
        changeChild(getClassName(), className);
        this.className = className;
    }

    protected ASTree getNameAST() {
        return getASTree().getSubTrees()[2];
    }

    public List getChildren() {
        List list = new ArrayList(6);
        addIfNotNull(list, getEnclosingClass()); 
        addIfNotNull(list, getClassName());
        list.addAll(super.getChildren());
        addIfNotNull(list, getClassDefinition());
        return list;
    }
    
    protected void initChildren() {
        childrenInited = false;
        ASTree tree = getASTree();
        if (tree != null) {
            ASTree[] parts = tree.getSubTrees();
            enclosingClass = (PrimaryExpression) initOrCreate(enclosingClass, parts[0]);
            className = (MultipartId) initOrCreate(className, parts[2]);
            parameters = createChildrenList(parameters, "parameters", parts[3], ASTreeTypes.ARGUMENT_LIST, CHANGED_PARAMETERS, false); // NOI18N
            ClassInfo newClassInfo = null;
            if (parts[4] != null) {
                newClassInfo = (ClassInfo)getParser().getSemanticInfo(parts[4], this);
            }
            if (classDefinition != null) {
                if (newClassInfo == null) {
                    changeChild(classDefinition, null);
                    classDefinition.refDelete();
                    classDefinition = null;
                } else {
                    ClassDefinitionImpl defImpl = (ClassDefinitionImpl)classDefinition;
                    
                    defImpl.updatePersistent(newClassInfo);
                    defImpl.setElementInfo(newClassInfo);
                }
            } else if (newClassInfo != null) {
                SemiPersistentElement spe=(SemiPersistentElement)JavaModelUtil.getDeclaringFeature(this);
                classDefinition = (ClassDefinition)spe.createElement(newClassInfo);
                changeChild(null, classDefinition);
            }
        }
        childrenInited = true;
    }

    public String getSourceText() {
        // delegate
        return getRawText();
    }
    
    String getRawText() {
        StringBuffer buf = new StringBuffer();
        if (enclosingClass != null) {
            //print enclosing class if it exist
            buf.append(((MetadataElement) enclosingClass).getSourceText());
            buf.append("."); // NOI18N
        }
        buf.append("new "); // NOI18N
        MultipartId className = getClassName();
        if (className != null) {
            buf.append(((MetadataElement) className).getSourceText());
        } else {
            buf.append(getName());
        }
        formatElementPart(PAR_OPEN_BRACKET, buf);
        Iterator iter = getParameters().iterator();
        while (iter.hasNext()) {
            //print parameters separated by commas
            StatementImpl par = (StatementImpl) iter.next();
            buf.append(par.getSourceText());
            if (iter.hasNext()) {
                formatElementPart(MetadataElement.COMMA, buf);
            }
        }
        formatElementPart(PAR_CLOSE_BRACKET, buf);
        
        ClassDefinition classDefinition = getClassDefinition();
        if (classDefinition != null) {
            //print class definition
            buf.append(((ClassDefinitionImpl) classDefinition).getSourceText());
        }
        return buf.toString();
    }
    
    private static final int ENCLOSING = 0;
    private static final int NAME = 2;
    private static final int PARAMS = 3;
    private static final int BODY = 4;

    public void getDiff(List diffList) {
        ASTProvider parser = getParser();
        ASTree[] children = getASTree().getSubTrees();
        
        //getChildDiff(diffList, parser, children[ENCLOSING], (MetadataElement) getEnclosingClass(), CHANGED_ENCLOSING_CLASS);
        //[TODO] following statement could be probably somehow replaced by getChildDiff, but it does not work for me now
        if (isChanged(CHANGED_ENCLOSING_CLASS) || ((enclosingClass != null) && ((MetadataElement) enclosingClass).isChanged())) {
            if (children[ENCLOSING] != null) {
                if (enclosingClass != null) {
                    //change
                    ((MetadataElement) enclosingClass).getDiff(diffList);
                } else {
                    //delete
                    diffList.add( new DiffElement(
                    parser.getToken(children[ENCLOSING].getFirstToken()).getStartOffset(),
                    parser.getToken(children[ENCLOSING].getLastToken()+1).getEndOffset(),
                    "")
                    );
                }
            } else {
                //print enclosing class and "."
                int startPos = parser.getToken(children[NAME].getFirstToken()-1).getStartOffset();
                diffList.add(new DiffElement(startPos, startPos, ((MetadataElement) enclosingClass).getSourceText() + ".")); // NOI18N
            }
        }
        getChildDiff(diffList, parser, children[NAME], (MetadataElement) getClassName(), CHANGED_CLASS_NAME);

        int endToken = children[PARAMS] != null ? children[PARAMS].getLastToken() : children[NAME].getLastToken() + 1;
        int endOffset = parser.getToken(endToken).getEndOffset(); 
        getCollectionDiff(diffList, parser, CHANGED_PARAMETERS, children[PARAMS], ASTreeTypes.ARGUMENT_LIST, getParameters(), endOffset, formatElementPart(MetadataElement.COMMA));
        int startToken = getASTree().getLastToken();
        getChildDiff(diffList, parser, children[BODY], (MetadataElement)getClassDefinition(), CHANGED_CLASS_DEFINITION, parser.getToken(startToken).getEndOffset(), null);
    }
    
    void setData(String name, List parameters, PrimaryExpression enclosingClass, ClassDefinition classDefinition, MultipartId className) {
        setData(name, parameters);
        changeChild(null, enclosingClass);
        this.enclosingClass = enclosingClass;
        changeChild(null, classDefinition);
        this.classDefinition = classDefinition;
        changeChild(null, className);
        this.className = className;
    }

    protected void _delete() {
        // --- delete components -------------------------------------------
        if (childrenInited) {
            deleteChild(enclosingClass);
            deleteChild(classDefinition);
            deleteChild(className);
        }
        // --- delete links -----------------------------------------------
        // no links to delete
        // --- call super ---------------------------------------
        super._delete();
    }
    
    public void replaceChild(Element oldElement,Element newElement) {
        if (childrenInited) {
            if (oldElement.equals(classDefinition)) {
                setClassDefinition((ClassDefinition)newElement);
            } else if (oldElement.equals(enclosingClass)) {
                setEnclosingClass((PrimaryExpression)newElement);
            } else if (oldElement.equals(className)) {
                setClassName((MultipartId)newElement);
            } else
                super.replaceChild(oldElement,newElement);
        }
    }

    public NamedElement getElement() {
        NamedElement el=(NamedElement) getParser().getSemanticInfo(getASTree(), this);
        
        if (el instanceof Constructor) {
            return el;
        }
        return null;
    }
    
    public Element duplicate(JavaModelPackage targetExtent) {
        return targetExtent.getNewClassExpression().createNewClassExpression(
                getName(),
                duplicateList(getParameters(), targetExtent),
                (PrimaryExpression) duplicateElement(getEnclosingClass(), targetExtent),
                (MultipartId) duplicateElement(getClassName(), targetExtent),
                (ClassDefinition) duplicateElement(getClassDefinition(), targetExtent)
               );
    }
}
