/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.modules.javacore.jmiimpl.javamodel;

import java.util.*;

import javax.jmi.reflect.ConstraintViolationException;
import javax.jmi.reflect.RefObject;

import org.netbeans.jmi.javamodel.*;
import org.netbeans.mdr.handlers.BaseObjectHandler;
import org.netbeans.mdr.handlers.ClassProxyHandler;
import org.netbeans.mdr.persistence.MOFID;
import org.netbeans.mdr.persistence.StorageException;
import org.netbeans.mdr.storagemodel.StorableBaseObject;
import org.netbeans.mdr.storagemodel.StorableClass;
import org.netbeans.mdr.util.DebugException;

/**
 *
 * @author  Dusan Balek
 */
public abstract class ParameterizedTypeClassImpl extends ClassProxyHandler implements ParameterizedTypeClass {
    private static final String MOFID_PREFIX = "parameterizedType:"; // NOI18N
    private static final InstanceMap allInstances = new InstanceMap();
    private static int increment = 0;
    
    public ParameterizedTypeClassImpl(StorableClass s) {
        super(s);
    }

    public ParameterizedType createParameterizedType() {
        throw new ConstraintViolationException(this, refMetaObject(), "Cannot create instance of ParameterizedType directly - use resolveParameterizedType instead."); // NOI18N
    }

    public ParameterizedType createParameterizedType(String name, List annotations, int modifiers, String javadocText, JavaDoc javadoc, List contents, MultipartId superClassName, List interfaceNames, List typeParameters) {
        throw new ConstraintViolationException(this, refMetaObject(), "Cannot create instance of ParameterizedType directly - use resolveParameterizedType instead."); // NOI18N
    }

    public ParameterizedType resolveParameterizedType(JavaClass def, List params, ParameterizedType outerCls) {
        if (def == null)
            return null;
        if (def instanceof ParameterizedTypeImpl) {
            outerCls = ((ParameterizedTypeImpl) def).outerCls;
            def = ((ParameterizedTypeImpl) def).definition;
        }
        if (params == null) {
            params = Collections.EMPTY_LIST;
        }
        
        _lock(false);
        try {
            CacheKey fullName = constructKey(def, params, outerCls);
            ParameterizedTypeImpl result = (ParameterizedTypeImpl) allInstances.get(fullName);
            if (result == null) {
                try {
                    StorableBaseObject s = _getDelegate();
                    MOFID mofId = new MOFID(increment, MOFID_PREFIX + increment++);
                    DeferredObject o = new DeferredObject(mofId, s.getMdrStorage(), s.getImmediatePackageId(), s.getOutermostPackageId(), s.getMetaObject(), (StorableClass) s, null);
                    result = (ParameterizedTypeImpl) _getRepository().getHandler(o);
                    result.definition = def;
                    result.parameters = params;
                    result.outerCls = outerCls;
                    allInstances.put(fullName, result);
                } catch (StorageException e) {
                    throw new DebugException();
                }
            }
            return result;
        } finally {
            _unlock();
        }
    }
    
    private CacheKey constructKey(JavaClass def, List params, ParameterizedType outerCls) {
        MOFID[] paramIds = new MOFID[params.size()];
        int i = 0;
        for (Iterator it = params.iterator(); it.hasNext(); i++) {
            BaseObjectHandler param = (BaseObjectHandler) it.next();
            paramIds[i] = param == null ? null : param._getMofId(); // NOI18N
        }
        return new CacheKey(((BaseObjectHandler) def)._getMofId(), paramIds, outerCls == null ? null : ((BaseObjectHandler) outerCls)._getMofId());
    }
    
    protected Collection _allOfClass(boolean recursive) {
        return allInstances.values();
    }
    
    public org.netbeans.jmi.javamodel.Type resolve(java.lang.String name) {
        JavaModelPackage pkg = (JavaModelPackage) refImmediatePackage();
        return pkg.getType().resolve(name);
    }
    
    private static class CacheKey {
        private final MOFID def, params[], outer;
        
        public CacheKey(MOFID def, MOFID[] params, MOFID outer) {
            if (def == null) throw new IllegalArgumentException();
            this.def = def;
            this.params = params;
            this.outer = outer;
        }
        
        public boolean equals(Object o) {
            if (!(o instanceof CacheKey)) return false;
            
            CacheKey ck = (CacheKey) o;
            if (params.length != ck.params.length) return false;
            
            for (int i = 0; i < params.length; i++) {
                if (!compare(params[i], ck.params[i])) return false;
            }
            
            if (!(compare(def, ck.def) && compare(outer, ck.outer))) return false;
            
            return true;
        }
        
        public int hashCode() {
            return def.hashCode() * 31 + params.length + (outer == null ? 0 : outer.hashCode());
        }
        
        private boolean compare(Object o1, Object o2) {
            return (o1 == null && o2 == null) || (o1 != null && o1.equals(o2));
        }
    }
}
