/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.modules.javacore.jmiimpl.javamodel;

import java.util.*;
import javax.jmi.reflect.*;
import org.netbeans.api.mdr.events.AssociationEvent;

import org.netbeans.mdr.storagemodel.*;
import org.netbeans.mdr.handlers.*;

/** This list wrapper is intended to assotiations persistent outside of MDR 
 *  repository, in this case in inner list. So this wrapper simulates MDR event
 *  system and asks MDR for lock/unlock support.
 *  Wrapper can also verify check type for add/remove operations.
 *
 * @author Vladimir Hudec
 */
public class ReferenceListWrapper extends ReferenceColWrapper implements List {
    private List innerList;
    
    /** Creates new ListWrapper */
    public ReferenceListWrapper(MdrStorage storage, AssociationHandler source, RefObject fixed, String endName, SemiPersistentElement parent, int changeMask, List inner) {
        super(storage, source, fixed, endName, parent, changeMask);
        setInnerList(inner);
    }
    
    public void setInnerList(List inner) {
        super.setInnerList(inner);
        this.innerList = inner;
    }
    
    public List getInnerList() {
        return innerList;
    }
    
    /** List operations */

    public Object remove(int param) {
        boolean fail = true;
        lock(true);
        try {
            Object result = (RefObject) get(param);
            if (storage.eventsEnabled()) {
                AssociationEvent event = new AssociationEvent(
                source,
                AssociationEvent.EVENT_ASSOCIATION_REMOVE,
                fixed, endName,
                (RefObject) result, null,
                param);
                notifier.firePlannedChange(source, event);
            }
            innerList.remove(param);
            objectChanged(result);
            fail = false;
            return result;
        } finally {
            unlock(fail);
        }
    }
    
    public void add(int param, Object obj) {
        checkType(obj);
        boolean fail = true;
        lock(true);
        try {
            if (storage.eventsEnabled()) {
                AssociationEvent event = new AssociationEvent(
                source,
                AssociationEvent.EVENT_ASSOCIATION_ADD,
                fixed, endName,
                null, (RefObject) obj,
                param);
                notifier.firePlannedChange(source, event);
            }
            innerList.add(param, obj);
            objectChanged(obj);
            fail = false;
        } finally {
            unlock(fail);
        }
    }
    
    
    public Object set(int param, Object obj) {
        checkType(obj);
        boolean fail = true;
        lock(true);
        try {
            Object result = get(param);
            if (storage.eventsEnabled()) {
                AssociationEvent event = new AssociationEvent(
                source,
                AssociationEvent.EVENT_ASSOCIATION_SET,
                fixed, endName,
                (RefObject) result, (RefObject) obj,
                param);
                notifier.firePlannedChange(source, event);
            }
            innerList.set(param, obj);
            objectChanged(result);
            objectChanged(obj);
            fail = false;
            return result;
        } finally {
            unlock(fail);
        }
    }
    
    public boolean addAll(int param, Collection collection) {
        boolean fail = true;
        lock(true);
        try {
            ListIterator lit = listIterator(param);
            for (Iterator it = collection.iterator(); it.hasNext();) {
                lit.add(it.next());
            }
            fail = false;
            return true;
        } finally {
            unlock(fail);
        }
    }
    
    public int indexOf(Object obj) {
        lock(false);
        try {
            return innerList.indexOf(obj);
        } finally {
            unlock();
        }
    }
    
    public int lastIndexOf(Object obj) {
        lock(false);
        try {
            return innerList.lastIndexOf(obj);
        } finally {
            unlock();
        }
    }
    
    public Object get(int param) {
        lock(false);
        try {
            return innerList.get(param);
        } finally {
            unlock();
        }
    }
    
    public ListIterator listIterator() {
        lock(false);
        try {
            return new ReferenceListIteratorWrapper(innerList.listIterator());
        } finally {
            unlock();
        }
    }
    
    public ListIterator listIterator(int param) {
        lock(false);
        try {
            return new ReferenceListIteratorWrapper(innerList.listIterator(param));
        } finally {
            unlock();
        }
    }
    
    public List subList(int param, int param1) {
        throw new UnsupportedOperationException();
        //        return new ListWrapper(((List) innerList).subList(param, param1), source);
    }
    
    public boolean equals(Object object) {
        if (object instanceof List) {
            return super.equals(object);
        } else {
            return false;
        }
    }
    
    protected class ReferenceListIteratorWrapper extends ReferenceIteratorWrapper implements ListIterator {
        private final ListIterator listIterator;
        private int lastReadIndex = 0;
        
        public ReferenceListIteratorWrapper(ListIterator innerIterator) {
            super(innerIterator);
            this.listIterator = innerIterator;
        }
        
        public void set(Object obj) {
            testModCount();
            checkType(obj);
            boolean fail = true;
            lock(true);
            try {
                if (storage.eventsEnabled()) {
                    AssociationEvent event = new AssociationEvent(
                    source,
                    AssociationEvent.EVENT_ASSOCIATION_SET,
                    fixed, endName,
                    (RefObject) lastRead, (RefObject) obj,
                    lastReadIndex);
                    notifier.firePlannedChange(source, event);
                }
                listIterator.set(obj);
                objectChanged(obj);
                objectChanged(lastRead);
                fail = false;
            } finally {
                unlock(fail);
            }
        }
        
        public void add(Object obj) {
            testModCount();
            checkType(obj);
            boolean fail = true;
            lock(true);
            try {
                if (storage.eventsEnabled()) {
                    AssociationEvent event = new AssociationEvent(
                    source,
                    AssociationEvent.EVENT_ASSOCIATION_ADD,
                    fixed, endName,
                    null, (RefObject) obj,
                    nextIndex());
                    notifier.firePlannedChange(source, event);
                }
                listIterator.add(obj);
                objectChanged(obj);
                fail = false;
            } finally {
                unlock(fail);
            }
        }
        
        public int previousIndex() {
            testModCount();
            lock(false);
            try {
                return listIterator.previousIndex();
            } finally {
                unlock();
            }
        }
        
        public int nextIndex() {
            testModCount();
            lock(false);
            try {
                return listIterator.nextIndex();
            } finally {
                unlock();
            }
        }
        
        public boolean hasPrevious() {
            testModCount();
            lock(false);
            try {
                return listIterator.hasPrevious();
            } finally {
                unlock();
            }
        }
        
        public Object previous() {
            testModCount();
            lock(false);
            try {
                lastReadIndex = previousIndex();
                return (lastRead = (RefObject) listIterator.previous());
            } finally {
                unlock();
            }
        }
        
        public Object next() {
            testModCount();
            lock(false);
            try {
                lastReadIndex = nextIndex();
                return super.next();
            } finally {
                unlock();
            }
        }
        
        public void remove() {
            testModCount();
            checkType(lastRead);
            boolean fail = true;
            lock(true);
            try {
                if (storage.eventsEnabled()) {
                    AssociationEvent event = new AssociationEvent(
                    source,
                    AssociationEvent.EVENT_ASSOCIATION_REMOVE,
                    fixed,
                    endName,
                    (RefObject) lastRead,
                    null,
                    lastReadIndex);
                    notifier.firePlannedChange(source, event);
                }
                innerIterator.remove();
                objectChanged(lastRead);
                fail = false;
            } finally {
                unlock(fail);
            }
        }
    }
}
