/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.modules.javacore.jmiimpl.javamodel;

import org.netbeans.jmi.javamodel.JavaModelPackage;
import org.netbeans.jmi.javamodel.MultipartId;
import org.netbeans.jmi.javamodel.Resource;
import org.netbeans.jmi.javamodel.ResourceClass;
import org.netbeans.mdr.handlers.ClassProxyHandler;
import org.netbeans.mdr.persistence.MOFID;
import org.netbeans.mdr.storagemodel.StorableBaseObject;
import org.netbeans.mdr.storagemodel.StorableClass;
import org.netbeans.mdr.storagemodel.StorableFeatured;
import org.netbeans.modules.javacore.JMManager;
import org.netbeans.modules.javacore.internalapi.JavaMetamodel;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import javax.jmi.reflect.ConstraintViolationException;
import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;

/**
 *
 * @author Martin Matula
 */
public abstract class ResourceClassImpl extends ClassProxyHandler implements ResourceClass {
    private static final String NAME_INDEX = "Java.Resource.name"; // NOI18N
    
    /** Creates a new instance of ResourceClassImpl */
    public ResourceClassImpl(StorableClass s) {
        super(s);
    }
    
    public Resource createResource(String name, long timestamp, List classifiers, List imports, String packageName, MultipartId packageIdentifier, List packageAnnotations) {
        assert !name.startsWith("/") : "Resource name cannot start with /"; // NOI18N
        if (resolveResource(name, false) == null) {
            // [TODO] should check whether the file already existed?
            FileObject f = createFile(name);
            //this approach does not work
            //ResourceImpl r = (ResourceImpl) super_createResource(name, timestamp, classifiers, imports, packageName);
            ResourceImpl r = (ResourceImpl) super_createResource(name, timestamp, null, null, null, null, null);
            r.setFileToDeleteOnRollback(f);
            r._setPackageName(packageName);
            r.objectChanged(MetadataElement.CHANGED_PACKAGE_NAME);
            r.getClassifiers().addAll(classifiers);
            r.getImports().addAll(imports);
            return r;
        } else {
            throw new ConstraintViolationException(this, refMetaObject(), "Resource named " + name + " already exists."); // NOI18N
        }
    }
    
    private FileObject createFile(String name) {

        FileObject currentFolder = ((JMManager) JavaMetamodel.getManager()).getCPRoot((JavaModelPackage) refImmediatePackage());
        StringTokenizer folderNames = new StringTokenizer(name,"/"); // NOI18N
        String newFolderName;
        FileObject newFolder;
        FileObject fileToDelete = null;
        
        //iterate through all folders and if they not exist, create them. Finally create a file
        
        while (folderNames.hasMoreTokens()) {
            newFolderName = folderNames.nextToken();
            if (folderNames.hasMoreTokens()) {
                //if this is not last token, it must be a folder
                newFolder = currentFolder.getFileObject(newFolderName);
                if (newFolder == null) {
                    try {
                        //if the folder does not exist - create it
                        newFolder = currentFolder.createFolder(newFolderName);
                        if (fileToDelete == null)
                            fileToDelete = newFolder; //I must delete topmost folder I created
                    } catch (IOException ioe){
                        ErrorManager.getDefault().notify(ioe);
                    }
                    
                } 
                currentFolder = newFolder;
            } else {
                //this is last token - it is a file name
                try {
                FileObject f = currentFolder.createData(newFolderName);
                if (fileToDelete == null)
                    fileToDelete = f;
                } catch (IOException ioe) {
                    ErrorManager.getDefault().notify(ioe);
                }
            }
        }
        return fileToDelete;
    }
    
    public Resource resolveResource(String name, boolean create, boolean createFile) {
        if (name == null || !(name.endsWith(".java") || name.endsWith(".class"))) return null; // NOI18N
        StorableFeatured storable = (StorableFeatured) _getDelegate();
        MOFID packageID = storable.getOutermostPackageId();        
        Collection items = storable.getMdrStorage().getObjectsFromAdditionalIndex(
            packageID,
            NAME_INDEX, 
            name);
        Resource res = null;
        if (items != null) {
            Iterator it = items.iterator();
            
            if (it.hasNext()) {
                StorableBaseObject sbo = (StorableBaseObject) it.next();
                
                if (it.hasNext()) {
                    // error: there is more than one element with the same descriptor
                    // [TODO] should handle error properly (using error manager/throw exception?)
                    ErrorManager.getDefault().log("Multiple Resource instances for " + name);
                }
                res = (Resource) _getRepository().getHandler(sbo);
                res = res != null && res.isValid() ? res : null;
            }
        }
        if (res == null && create) {
            assert !name.startsWith("/") : "Resource name cannot start with /"; // NOI18N
            if (createFile) {
                // [TODO] should check whether the name already existed?
                createFile(name);
            }
            return super_createResource(name, 0, null, null, null, null, null);
        } else {
            return res;
        }
    }
    
    public Resource resolveResource(String name, boolean create) {
        return resolveResource(name, create, true);
    }
    
    public Resource createResource() {
        ResourceImpl ret=(ResourceImpl)super_createResource();
        ret.setNew();
        ret.setData();
        return ret;
    }
    
    protected abstract Resource super_createResource(String name, long timestamp, List classifiers, List imports, String packageName, MultipartId packageIdentifier, List packageAnnotations);
    protected abstract Resource super_createResource();
}
