/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.modules.javacore.jmiimpl.javamodel;

import org.netbeans.jmi.javamodel.*;
import org.netbeans.lib.java.parser.ASTree;
import org.netbeans.mdr.storagemodel.StorableObject;
import org.netbeans.lib.java.parser.ASTreeTypes;
import org.netbeans.lib.java.parser.ParserTokens;


/**
 *
 * @author Martin Matula
 */
public abstract class StatementImpl extends TransientElement implements ParserTokens {
    /** Creates a new instance of StatementImpl */
    public StatementImpl(StorableObject o) {
        super(o);
    }
    
    static Operator getOperator(int type) {
        switch (type) {
            case ASSIGN:
                return OperatorEnum.ASSIGN;
            case PLUS_ASSIGN:
                return OperatorEnum.PLUSASSIGN;
            case MINUS_ASSIGN:
                return OperatorEnum.MINUSASSIGN;
            case MULTI_ASSIGN:
                return OperatorEnum.MULTIASSIGN;
            case DIV_ASSIGN:
                return OperatorEnum.DIVASSIGN;
            case AND_ASSIGN:
                return OperatorEnum.ANDASSIGN;
            case OR_ASSIGN:
                return OperatorEnum.ORASSIGN;
            case XOR_ASSIGN:
                return OperatorEnum.XORASSIGN;
            case MOD_ASSIGN:
                return OperatorEnum.MODASSIGN;
            case L_SHIFT_ASSIGN:
                return OperatorEnum.LSHIFTASSIGN;
            case R_SHIFT_ASSIGN:
                return OperatorEnum.RSHIFTASSIGN;
            case UR_SHIFT_ASSIGN:
                return OperatorEnum.URSHIFTASSIGN;
            case MINUS:
                return OperatorEnum.MINUS;
            case PLUS:
                return OperatorEnum.PLUS;
            case MULTI:
                return OperatorEnum.MULTI;
            case AND:
                return OperatorEnum.AND;
            case DIV:
                return OperatorEnum.DIV;
            case COMP:
                return OperatorEnum.COMP;
            case DECREMENT:
                return OperatorEnum.DEC;
            case EQ:
                return OperatorEnum.EQUAL;
            case GT:
                return OperatorEnum.GT;
            case GTE:
                return OperatorEnum.GTE;
            case INCREMENT:
                return OperatorEnum.INC;
            case BOOL_AND:
                return OperatorEnum.LAND;
            case BOOL_OR:
                return OperatorEnum.LOR;
            case L_SHIFT:
                return OperatorEnum.LSHIFT;
            case LT:
                return OperatorEnum.LT;
            case LTE:
                return OperatorEnum.LTE;
            case MOD:
                return OperatorEnum.MOD;
            case NEQ:
                return OperatorEnum.NEQUAL;
            case NOT:
                return OperatorEnum.NOT;
            case OR:
                return OperatorEnum.OR;
            case R_SHIFT:
                return OperatorEnum.RSHIFT;
            case UR_SHIFT:
                return OperatorEnum.URSHIFT;
            case XOR:
                return OperatorEnum.XOR;
            case INSTANCEOF:
                return OperatorEnum.INSTANCEOF;
            default:
                return null;
        }
    }                
}
