/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.modules.javacore.jmiimpl.javamodel;

import org.netbeans.jmi.javamodel.Element;
import org.netbeans.jmi.javamodel.Expression;
import org.netbeans.jmi.javamodel.SwitchStatement;
import org.netbeans.lib.java.parser.ASTree;
import org.netbeans.lib.java.parser.ASTreeTypes;
import org.netbeans.mdr.storagemodel.StorableObject;
import org.netbeans.modules.javacore.parser.ASTProvider;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.netbeans.jmi.javamodel.JavaModelPackage;

/**
 *
 * @author  Martin Matula
 */
public abstract class SwitchStatementImpl extends ConditionImpl implements SwitchStatement {
    private LightAttrList cases = null;
    
    /** Creates a new instance of SwitchStatementImpl */
    public SwitchStatementImpl(StorableObject o) {
        super(o);
    }
    
    public List getCases() {
        if (!childrenInited) {
            initChildren();
        }
        return cases;
    }
    
    public List getChildren() {
        List list = super.getChildren();
        list.addAll(getCases()); 
        return list;
    }
    
    protected void initChildren() {
        childrenInited = false;
        ASTree tree = getASTree();
        if (tree != null) {
            ASTree[] parts = tree.getSubTrees();
            expression = (Expression) initOrCreate(expression, parts[0]);
            ASTree[] block = parts[1].getSubTrees();
            ArrayList children = new ArrayList();
            if (block[0] != null) {
                ASTree[] groups = block[0].getSubTrees();
                for (int i = 0; i < groups.length; i++) {
                    ASTree[] cases = groups[i].getSubTrees();
                    if (cases[0].getType() == ASTreeTypes.SWITCH_LABELS) {
                        ASTree[] labels = cases[0].getSubTrees();
                        for (int j = 0; j < labels.length - 1; j++) {
                            children.add(labels[j]);
                        }
                    }
                    children.add(groups[i]);
                }
            }
            if (block[1] != null) {
                if (block[1].getType() == ASTreeTypes.SWITCH_LABELS) {
                    ASTree[] labels = block[1].getSubTrees();
                    for (int j = 0; j < labels.length; j++) {
                        children.add(labels[j]);
                    }
                }
            }
            cases = createChildrenList(cases, "cases", (ASTree[]) children.toArray(new ASTree[children.size()]), CHANGED_CASES, false); // NOI18N
        }
        childrenInited = true;
    }
    
    public String getRawText() {
        StringBuffer buf = new StringBuffer();
        List cases = getCases();
        TransientElement expr = (TransientElement) getExpression();
        formatElementPart(SWITCH_KEYWORD, buf, isNew());
        formatElementPart(STMT_OPEN_BRACKET, buf);
        buf.append(expr.getSourceText());
        formatElementPart(STMT_CLOSE_BRACKET, buf);
        formatElementPart(BLOCK_OPEN_CURLY, buf);
        for (Iterator iter = cases.iterator(); iter.hasNext();) {
            CaseImpl casik = (CaseImpl) iter.next();
            buf.append(casik.getSourceText());
        }
        formatElementPart(BLOCK_CLOSE_CURLY, buf);
        return buf.toString();
    }

    public void getDiff(List diff) {
        if (isChanged()) {
            ASTProvider parser = getParser();
            ASTree tree = getASTree();
            
            if (isChanged(CHANGED_CASES)) {
                diff.add(new DiffElement(parser.getToken(tree.getFirstToken()).getStartOffset(), parser.getToken(tree.getLastToken()).getEndOffset(), getSourceText()));
            } else {
                getChildDiff(diff, parser, tree.getSubTrees()[0], (MetadataElement) getExpression(), CHANGED_EXPRESSION);
                if (isChanged(CHANGED_CHILDREN)) {
                    for (Iterator it = getCases().iterator(); it.hasNext();) {
                        CaseImpl c = (CaseImpl) it.next();
                        if (c.isChanged()) {
                            c.getDiff(diff);
                        }
                    }
                }
            }
        }
    }
    
    void setData(Expression expression, List cases) {
        // expression
        changeChild(null, expression);
        this.expression = expression;
        // cases
        this.cases = createChildrenList("cases", cases, CHANGED_CASES); // NOI18N
    }

    protected void _delete() {
        // --- delete components -------------------------------------------
        if (childrenInited) {
            deleteChildren(cases);
        }
        // --- delete links -----------------------------------------------
        // no links to delete
        // --- call super ---------------------------------------
        super._delete();
    }
    
    public void replaceChild(Element oldElement,Element newElement) {
        if (childrenInited) {
            if (replaceObject(getCases(),oldElement,newElement))
                return;
            super.replaceChild(oldElement,newElement);
        }
    }
    
    public Element duplicate(JavaModelPackage targetExtent) {
        return targetExtent.getSwitchStatement().createSwitchStatement(
                (Expression) duplicateElement(getExpression(), targetExtent),
                duplicateList(getCases(), targetExtent)
               );
    }
}
